import express from "express";
const router = express.Router();
import { authenticateToken } from '../middlewares/auth.middleware.js';
import { login } from "../controllers/authController.js"; // Adjust the path if needed

// Login route

router.post('/login', login);

// 🔐 Protected route to test Bearer token
router.get('/protected', authenticateToken, (req, res) => {
  res.json({ message: "You are authorized", user: req.user });
});

export default router;


