// database.js
import dotenv from "dotenv";
dotenv.config();

import mysql from "mysql2/promise";

// Create the connection pool using createPool
const pool = mysql.createPool({
  user: process.env.DB_USER,
  host: process.env.DB_HOST,
  database: process.env.DB_NAME,
  password: process.env.DB_PASSWORD,
  port: process.env.DB_PORT,
  waitForConnections: true,
  connectionLimit: 10,
  queueLimit: 0,
});

//console.log(pool);
// Test the connection (without ending the pool)
(async () => {
  try {
    const [rows] = await pool.query("SELECT NOW()");
    console.log(pool);
    console.log("Database connection successful:", rows[0]);
  } catch (error) {
    console.error("Database connection failed:", error.message);
  }
})();

export default pool;
