import { getUserByLoginId } from "../models/user.model.js"; // Adjust the path as necessary
import jwt from 'jsonwebtoken';

const JWT_SECRET = process.env.JWT_SECRET;

export const login = async (req, res) => {
  const { username, password } = req.body;

  if (!username || !password) {
    return res.status(400).json({ message: "Login ID and password are required" });
  }

  try {
    const user = await getUserByLoginId(username);
    console.log('user', user);

    if (!user) {
      return res.status(404).json({ message: "User not found" });
    }

    // Decode base64 stored password and compare with input
    const decodedPassword = Buffer.from(user.password, 'base64').toString('utf8');

    if (decodedPassword !== password) {
      return res.status(401).json({ message: "Invalid credentials" });
    }

    const token = await jwt.sign({
      id: user.id,
      role: user.role,
      name: user.fullname,
      email: user.email,
    }, JWT_SECRET, { expiresIn: '1h' });

    return res.status(200).json({
      message: "Login successful",
      token,
      user: {
        id: user.id,
        role: user.role,
        name: user.fullname,
        email: user.email,
      },
    });

  } catch (error) {
    return res.status(500).json({ message: "Internal server error", error: error.message });
  }
};
