import express from 'express';
import dotenv from 'dotenv';
import authRoutes from './routes/authRoutes.js'; // Adjust if needed

// Load environment variables from .env file
dotenv.config();

// Initialize Express app
const app = express();

// Middleware to parse incoming requests
app.use(express.json()); // For application/json
app.use(express.urlencoded({ extended: true })); // For x-www-form-urlencoded

// Routes
app.use("/api/auth", authRoutes); // All auth routes mounted here

// Start server
const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
  console.log(`🚀 Server running at http://localhost:${PORT}`);
});

