'use client';
import React, { useEffect, useState } from 'react';
import Link from 'next/link';
import AOS from 'aos';
import 'aos/dist/aos.css';


interface FAQItem {
    question: string;
    answer: string;
}

interface FAQAccordionProps {
    faqs: FAQItem[];
}

const IntFaq: React.FC<FAQAccordionProps> = ({ faqs }) => {
     const [openIndex, setOpenIndex] = useState<number | null>(0);

    useEffect(() => {

        AOS.init({
            duration: 800,
            easing: 'ease-in-out',
            once: true,
        });
    }, []);

    const handleToggle = (index: number) => {
        setOpenIndex(openIndex === index ? null : index);
    };

    return (
        <div className="faq-container mb-4" data-aos="fade-up" data-aos-delay="100">

            <h3 className="mb-4 text-primary">FAQs About Tour Packages</h3>

            <div className="faq-accordion">
                {faqs.map((faq, index) => (
                    <div className="faq-item" key={index} data-aos="fade-up" data-aos-delay={`${200 + index * 100}`}>
                        <div
                            className={`d-flex align-items-center faq-question ${openIndex === index ? 'active' : ''}`}
                            onClick={() => handleToggle(index)}
                        >
                            <span className="me-3">Q</span> {faq.question}
                            <span className="faq-arrow"></span>
                        </div>
                        <div
                            className={`faq-answer ${openIndex === index ? 'open' : ''}`}
                        >
                            <span className="me-2">A</span> {faq.answer}
                        </div>
                    </div>
                ))}
            </div>
        </div>
    );
};

export default IntFaq;