"use client";
import React, { useState, useRef, useEffect } from "react";

interface ExpandableTextProps {
  title: string;
  subtitle?: string;
  text: string;
  collapsedLines?: number;
}

const IntExpandableText: React.FC<any> = ({ data, collapsedLines = 2 }) => {
  const [expanded, setExpanded] = useState(false);
  const [maxHeight, setMaxHeight] = useState<string>("0px");
  const [showButton, setShowButton] = useState(true);
  const textRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    if (textRef.current) {
      const lineHeight = parseInt(
        window.getComputedStyle(textRef.current).lineHeight
      );
      const collapsedHeight = lineHeight * collapsedLines;
      const scrollHeight = textRef.current.scrollHeight;

      setMaxHeight(expanded ? `${scrollHeight}px` : `${collapsedHeight}px`);
      setShowButton(scrollHeight > collapsedHeight && !expanded);
    }
  }, [expanded, collapsedLines, data.description]);

  const stripHtml = (html: string) => {
    if (!html) return "";
    return html
      .replace(/<[^>]+>/g, "")
      .replace(/\s+/g, " ")
      .trim();
  };


  return (
    <div className="tourCard  mb-4 shadow-sm p-3 p-lg-4">
      <h3 className="mb-3">International Tour Packages</h3>

      <div
        ref={textRef}
        className={`overflow-hidden transition-all duration-500 ease-in-out text-expansion ${
          !expanded ? "line-clamp-2" : ""
        }`}
        style={{ maxHeight }}
      >
        <p className="text-sm mb-0">
          {stripHtml(data.description)}
          {/* {!expanded && <span className="ellipsis">...</span>} */}
        </p>
      </div>

      {showButton && (
        <button
          onClick={() => setExpanded(true)}
          className="btn btn-link mt-2 p-0 text-primary text-decoration-none d-flex align-items-center"
        >
          <span>More</span>
          <svg
            className={`ms-2 arrow-icon ${expanded ? "rotate" : ""}`}
            width="16"
            height="16"
            fill="none"
            stroke="currentColor"
            viewBox="0 0 24 24"
            xmlns="http://www.w3.org/2000/svg"
          >
            <path
              strokeLinecap="round"
              strokeLinejoin="round"
              strokeWidth={2}
              d="M19 9l-7 7-7-7"
            />
          </svg>
        </button>
      )}
    </div>
  );
};

export default IntExpandableText;
