"use client";

import Image from "next/image";
import React, { useRef } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import { Autoplay } from "swiper/modules";
import type { Swiper as SwiperType } from "swiper";

import "swiper/css";
import "swiper/css/pagination";
import "swiper/css/navigation";


const LogoSlider = () => {
    const swiperRef = useRef<SwiperType | null>(null);


return (
    <section className="logo-slider-sec common-padd pt-0">
        <div className="container">
            <div
                onMouseEnter={() => swiperRef.current?.autoplay?.stop()}
                onMouseLeave={() => swiperRef.current?.autoplay?.start()}
                >
            <Swiper
                modules={[Autoplay]}
                onSwiper={(swiper) => (swiperRef.current = swiper)}
                loop={true}
                autoplay={{
                delay: 3000,
                disableOnInteraction: false,
                }}
                spaceBetween={30}
                slidesPerView={5}
                breakpoints={{
                320: {
                    slidesPerView: 1,
                },
                768: {
                    slidesPerView: 2,
                },
                1024: {
                    slidesPerView: 5,
                },
                }}
            >
                <SwiperSlide>
                    <div className="logo-box">
                        <Image
                            width={150}
                            height={60}
                            sizes="100vw"
                            src="/images/logo2.png"
                            alt=""
                            className=""
                        />
                    </div>
                </SwiperSlide>
                <SwiperSlide>
                    <div className="logo-box">
                        <Image
                            width={150}
                            height={60}
                            sizes="100vw"
                            src="/images/logo3.png"
                            alt=""
                            className=""
                        />
                    </div>
                </SwiperSlide>
                <SwiperSlide>
                    <div className="logo-box">
                        <Image
                            width={150}
                            height={60}
                            sizes="100vw"
                            src="/images/logo3.png"
                            alt=""
                            className=""
                        />
                    </div>
                </SwiperSlide>
                <SwiperSlide>
                    <div className="logo-box">
                        <Image
                            width={150}
                            height={60}
                            sizes="100vw"
                            src="/images/logo3.png"
                            alt=""
                            className=""
                        />
                    </div>
                </SwiperSlide>
                <SwiperSlide>
                    <div className="logo-box">
                        <Image
                            width={150}
                            height={60}
                            sizes="100vw"
                            src="/images/logo3.png"
                            alt=""
                            className=""
                        />
                    </div>
                </SwiperSlide>
                <SwiperSlide>
                    <div className="logo-box">
                        <Image
                            width={150}
                            height={60}
                            sizes="100vw"
                            src="/images/logo3.png"
                            alt=""
                            className=""
                        />
                    </div>
                </SwiperSlide>
                <SwiperSlide>
                    <div className="logo-box">
                        <Image
                            width={150}
                            height={60}
                            sizes="100vw"
                            src="/images/logo3.png"
                            alt=""
                            className=""
                        />
                    </div>
                </SwiperSlide>
            </Swiper>
            </div>
        </div>
    </section>
  );
};

export default LogoSlider;
