"use client";
import React, { useState } from "react";
import Image from "next/image";
import Link from "next/link";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination, Autoplay } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import { useRef } from "react";
import { Swiper as SwiperType } from "swiper";
import { devImgPath } from "@/app/urls/imageUrl";
import { useRouter } from "next/navigation";

const IndiaTourPackage = ({ exclusiveIndiaPackage }: any) => {
  const swiperRef = useRef<SwiperType | null>(null);

  const router = useRouter();

  const setUrl = (slug: any, displaySlug: any) => {
    router.push(`/packages/${slug}`);
  };

  return (
    <section className="tourpackege-sec common-padd using-for-dubbl-slider">
      <div className="container">
        <div className="common-header-center">
          <h2>Exclusive India Tour Packages</h2>
        </div>
        <div
          onMouseEnter={() => swiperRef.current?.autoplay?.stop()}
          onMouseLeave={() => swiperRef.current?.autoplay?.start()}
        >
          <Swiper
            modules={[Pagination, Autoplay]}
            onSwiper={(swiper) => (swiperRef.current = swiper)}
            pagination={{ clickable: true }}
            autoplay={{ delay: 3000 }}
            loop={true}
            spaceBetween={30}
            slidesPerView={3}
            breakpoints={{
              0: {
                slidesPerView: 1,
              },
              640: {
                slidesPerView: 2,
              },
              1024: {
                slidesPerView: 3,
              },
            }}
          >
            {exclusiveIndiaPackage?.map((exclusive: any) => (
              <SwiperSlide key={exclusive.id}>
                <div className="slider-card">
                  <div className="sngl-card-wraper">
                    <div className="image-box">
                      {/* <ul>
                        <li>HIGH DEMAND</li>
                        <li>FOOD & BEVERAGES</li>
                      </ul> */}
                      <div className="slider-box">
                        <div
                          onMouseEnter={() =>
                            swiperRef.current?.autoplay?.stop()
                          }
                          onMouseLeave={() =>
                            swiperRef.current?.autoplay?.start()
                          }
                          style={{ position: "relative" }} // ensure pagination positions correctly
                        >
                          <Swiper
                            modules={[Navigation, Pagination]}
                            navigation
                            pagination={{
                              clickable: true,
                              type: "custom",
                              renderCustom: (swiper, current, total) => {
                                return `<span class="custom-pagination">${current} / ${total}</span>`;
                              },
                            }}
                            loop={true}
                            spaceBetween={30}
                            slidesPerView={1}
                            onSwiper={(swiper) => {
                              swiperRef.current = swiper;
                            }}
                          >
                            {exclusive.images.map((img: any) => (
                              <SwiperSlide key={img.id}>
                                <div className="slider-content">
                                  <div className="slider-content-wraper">
                                    <Image
                                      width={800}
                                      height={600}
                                      sizes="100vw"
                                      src={img.image_path}
                                      alt="Slide 1"
                                    />
                                  </div>
                                </div>
                              </SwiperSlide>
                            ))}
                          </Swiper>
                        </div>
                      </div>
                    </div>
                    <div className="content-box">
                      <h3>{exclusive.title}</h3>
                      <ul className="location-box">
                        <li>
                          <div className="left-area">
                            <span>
                              <Image
                                width={12}
                                height={12}
                                sizes="100vw"
                                src="/images/location.png"
                                alt=""
                                className=""
                              />
                            </span>
                            {exclusive.location.country.name}
                          </div>
                          <div className="right-area">
                            <Image
                              width={80}
                              height={12}
                              sizes="100vw"
                              src="/images/star.png"
                              alt=""
                              className=""
                            />
                          </div>
                        </li>
                      </ul>
                      <ul className="fecility-box">
                        <li>
                          <span>
                            <Image
                              width={16}
                              height={16}
                              sizes="100vw"
                              src="/images/flight.png"
                              alt=""
                              className=""
                            />
                          </span>
                          Flights
                        </li>
                        <li>
                          <span>
                            <Image
                              width={16}
                              height={16}
                              sizes="100vw"
                              src="/images/moon.png"
                              alt=""
                              className=""
                            />
                          </span>
                          {exclusive.details.duration_nights} Nights
                        </li>
                        <li>
                          <span>
                            <Image
                              width={16}
                              height={16}
                              sizes="100vw"
                              src="/images/bus.png"
                              alt=""
                              className=""
                            />
                          </span>
                          Transfers
                        </li>
                        <li>
                          <span>
                            <Image
                              width={16}
                              height={16}
                              sizes="100vw"
                              src="/images/food.png"
                              alt=""
                              className=""
                            />
                          </span>
                          Breakfast
                        </li>
                      </ul>
                      <div className="btm-btn">
                        <button
                          onClick={() =>
                            setUrl(exclusive.slug, exclusive.display_slug)
                          }
                          className="btn blue-btn"
                        >
                          Explore More
                          <span>
                            <Image
                              width={23}
                              height={23}
                              sizes="100vw"
                              src="/images/button-arrow.png"
                              alt=""
                              className=""
                            />
                          </span>
                        </button>
                      </div>
                    </div>
                  </div>
                </div>
              </SwiperSlide>
            ))}
          </Swiper>
        </div>
        <div className="btm-button text-center mt-4">
          <Link href={`/${exclusiveIndiaPackage[0].location.country.name}/${exclusiveIndiaPackage[0].location.country.slug}`} className="btn blue-btn">
            View All
            <span>
              <Image
                width={23}
                height={23}
                sizes="100vw"
                src="/images/button-arrow.png"
                alt=""
                className=""
              />
            </span>
          </Link>
        </div>
      </div>
    </section>
  );
};

export default IndiaTourPackage;
