"use client";
import React from "react";
import Image from "next/image";
import Link from "next/link";
import { devImgPath } from "@/app/urls/imageUrl";
import { useRouter } from "next/navigation";

const HoneymoonPackage = ({ data }: any) => {
  const router = useRouter();

  const setUrl = (slug: any, displaySlug: any) => {
    router.push(`/packages/${slug}`);
  };

  return (
    <section className="honeymoon-tour-sec common-padd">
      <Image
        width={1920}
        height={900}
        sizes="100vw"
        src={data?.banner_image}
        alt={data?.title}
        className=""
      />
      <div className="container">
        <div className="content-box">
          <h2>{data?.package.title}</h2>
          <p>{`${data?.package.details.duration_nights} Nights / ${data?.package.details.duration_days} Days`}
          {/* Starts from ₹ ${data.package.price}* INR`} */}
          </p>
          <button
            onClick={() => setUrl(data.package.slug, data.package.display_slug)}
            className="btn blue-btn"
          >
            Book Now
            <span>
              <Image
                width={23}
                height={23}
                sizes="100vw"
                src="/images/button-arrow.png"
                alt=""
                className=""
              />
            </span>
          </button>
        </div>
      </div>
    </section>
  );
};

export default HoneymoonPackage;
