"use client";
import React from "react";
import Image from "next/image";
import Link from "next/link";
import { Swiper, SwiperSlide } from 'swiper/react';
import { Navigation, Pagination, Autoplay } from 'swiper/modules';
import 'swiper/css';
import 'swiper/css/navigation';
import 'swiper/css/pagination';
import { useRef } from 'react';
import { Swiper as SwiperType } from 'swiper';
import { devImgPath } from "@/app/urls/imageUrl";

const HomeBanner = ({bannerData}: any) => {

    const swiperRef = useRef<SwiperType | null>(null);


    return (
        <section className="banner-section">
            <div className="container">
                <div className="row">
                    <div className="col-lg-7">

                        <div className="left-box">

                            <div
                                onMouseEnter={() => swiperRef.current?.autoplay?.stop()}
                                onMouseLeave={() => swiperRef.current?.autoplay?.start()}
                            >
                                <Swiper

                                    modules={[Navigation, Pagination, Autoplay]}
                                    navigation
                                    pagination={{ clickable: true }}
                                    autoplay={{ delay: 3000 }}
                                    loop={true}
                                    spaceBetween={30}
                                    slidesPerView={1}
                                    onSwiper={(swiper) => {
                                        swiperRef.current = swiper;
                                    }}
                                >
                                    {bannerData?.slider_banners?.map((img: any) => (
                                        <SwiperSlide key={img.id}>
                                            <div className="slider-content">


                                                <div className="slider-content-wraper">
                                                    <Image
                                                        width={800}
                                                        height={600}
                                                        sizes="100vw"
                                                        src= {img.banner_image}
                                                        alt={img.title}
                                                        className=""
                                                    />
                                                    <div className="button">
                                                        <Link href={`/packages/${img.package.slug}`} className="btn orange-btn">
                                                            Explore now
                                                            <span>
                                                                <Image
                                                                    width={23}
                                                                    height={23}
                                                                    sizes="100vw"
                                                                    src="/images/button-arrow.png"
                                                                    alt=""
                                                                    className=""
                                                                />
                                                            </span>
                                                        </Link>
                                                    </div>
                                                </div>


                                            </div>
                                        </SwiperSlide>
                                    ))}

                                </Swiper>

                            </div>

                        </div>

                    </div>
                    <div className="col-lg-5">
                        <div className="right-box">
                            <div className="slider-content">
                                <div className="slider-content-wraper">
                                        <Image
                                            width={800}
                                            height={600}
                                            sizes="100vw"
                                            src= {bannerData.single_banner.banner_image}
                                            alt=""
                                            className=""
                                        />
                                    <div className="button">
                                        <h2 className="text-white">Experience the memory of Hot Air Balloon with Cholan Tours</h2>
                                        <div className="btm-sec">
                                            <Link href={`/packages/${bannerData.single_banner.package.slug}`} className="btn blue-btn">
                                                Book Now
                                                <span>
                                                    <Image
                                                        width={23}
                                                        height={23}
                                                        sizes="100vw"
                                                        src="/images/button-arrow.png"
                                                        alt=""
                                                        className=""
                                                    />
                                                </span>
                                            </Link>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    );
};

export default HomeBanner;
