// 'use client';

// import Image from 'next/image';
// import 'bootstrap/dist/css/bootstrap.min.css';
// import AOS from 'aos';
// import 'aos/dist/aos.css';
// import { useEffect } from 'react';
// import Link from 'next/link';

// export default function TravelPackages({internationalData}: any) {
//   useEffect(() => {
//     AOS.init({
//       duration: 800,
//       easing: 'ease-in-out',
//       once: true,
//     });
//   }, []);

//   return (
//     <div className="deals-packages bg-gray-100 py-5">
//       <div className="container">
//         <h2 className="text-primary text-center mb-5">Deals You Can't Miss</h2>
//         <div className="row row-cols-1 row-cols-md-3 g-4">
//           {/* Column 1 */}
//           <div className="col-lg-5">
//             <div className="row g-4">

//               <div className="col-lg-12">
//                 <Link href="/destination/seychelles">
//                   <div className="position-relative overflow-hidden rounded h-56 flex items-stretch">
//                     <Image
//                       src="/images/tour/city.webp"
//                       alt="Seychelles"
//                       width={400}
//                       height={300}
//                       className="rounded w-100 h-full object-cover transition-all duration-500 hover:scale-110 hover:brightness-90"
//                     />
//                     <div className="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent flex items-end p-4">
//                       <div>
//                         <h5 className="text-white text-center">Seychelles</h5>
//                         <h6 className="text-white text-center">8 Nights / 9 days</h6>
//                       </div>
//                     </div>
//                   </div>
//                 </Link>
//               </div>

//               <div className="col-lg-6">
//                 <Link href="/destination/seychelles">
//                   <div className="position-relative overflow-hidden rounded h-56 flex items-stretch">
//                     <Image
//                       src="/images/tour/city.webp"
//                       alt="Seychelles"
//                       width={400}
//                       height={300}
//                       className="rounded w-100 h-full object-cover transition-all duration-500 hover:scale-110 hover:brightness-90"
//                     />
//                     <div className="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent flex items-end p-4">
//                       <div>
//                         <h5 className="text-white text-center">Seychelles</h5>
//                         <h6 className="text-white text-center">8 Nights / 9 days</h6>
//                       </div>
//                     </div>
//                   </div>
//                 </Link>
//               </div>

//               <div className="col-lg-6">
//                 <Link href="/destination/seychelles">
//                   <div className="position-relative overflow-hidden rounded h-56 flex items-stretch">
//                     <Image
//                       src="/images/tour/city.webp"
//                       alt="Seychelles"
//                       width={400}
//                       height={300}
//                       className="rounded w-100 h-full object-cover transition-all duration-500 hover:scale-110 hover:brightness-90"
//                     />
//                     <div className="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent flex items-end p-4">
//                       <div>
//                         <h5 className="text-white text-center">Seychelles</h5>
//                         <h6 className="text-white text-center">8 Nights / 9 days</h6>
//                       </div>
//                     </div>
//                   </div>
//                 </Link>
//               </div>

//             </div>
//           </div>

//           {/* Column 2 */}
//           <div className="col-lg-3">
//             <Link href="/destination/seychelles">
//               <div className="position-relative overflow-hidden rounded h-100 flex items-stretch">
//                 <Image
//                   src="/images/tour/city.webp"
//                   alt="Seychelles"
//                   width={400}
//                   height={300}
//                   className="rounded w-100 h-full object-cover transition-all duration-500 hover:scale-110 hover:brightness-90"
//                 />
//                 <div className="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent flex items-end p-4">
//                   <div>
//                     <h5 className="text-white text-center">Seychelles</h5>
//                     <h6 className="text-white text-center">8 Nights / 9 days</h6>
//                   </div>
//                 </div>
//               </div>
//             </Link>
//           </div>

//           {/* Column 3 */}
//           <div className="col-lg-4">
//             <div className="row g-4">

//               <div className="col-lg-12">
//                 <Link href="/destination/seychelles">
//                   <div className="position-relative overflow-hidden rounded h-56 flex items-stretch">
//                     <Image
//                       src="/images/tour/city.webp"
//                       alt="Seychelles"
//                       width={400}
//                       height={300}
//                       className="rounded w-100 h-full object-cover transition-all duration-500 hover:scale-110 hover:brightness-90"
//                     />
//                     <div className="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent flex items-end p-4">
//                       <div>
//                         <h5 className="text-white text-center">Seychelles</h5>
//                         <h6 className="text-white text-center">8 Nights / 9 days</h6>
//                       </div>
//                     </div>
//                   </div>
//                 </Link>
//               </div>

//               <div className="col-lg-12">
//                 <Link href="/destination/seychelles">
//                   <div className="position-relative overflow-hidden rounded h-56 flex items-stretch">
//                     <Image
//                       src="/images/tour/city.webp"
//                       alt="Seychelles"
//                       width={400}
//                       height={300}
//                       className="rounded w-100 h-full object-cover transition-all duration-500 hover:scale-110 hover:brightness-90"
//                     />
//                     <div className="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent flex items-end p-4">
//                       <div>
//                         <h5 className="text-white text-center">Seychelles</h5>
//                         <h6 className="text-white text-center">8 Nights / 9 days</h6>
//                       </div>
//                     </div>
//                   </div>
//                 </Link>
//               </div>
              
//             </div>
//           </div>
//         </div>
//       </div>
//     </div>
//   );
// }



'use client';

import Image from 'next/image';
import 'bootstrap/dist/css/bootstrap.min.css';
import AOS from 'aos';
import 'aos/dist/aos.css';
import { useEffect } from 'react';
import Link from 'next/link';

export default function TravelPackages({ internationalData }: any) {
  useEffect(() => {
    AOS.init({
      duration: 800,
      easing: 'ease-in-out',
      once: true,
    });
  }, []);

  if (!internationalData || internationalData.length === 0) return null;

  const leftColumn = internationalData.slice(0, 3); // 1 large + 2 small
  const middleColumn = internationalData[3];        // 1 tall card
  const rightColumn = internationalData.slice(4, 6); // 2 cards

  const renderCard = (item: any, isFullWidth: boolean = true, height = 'h-56') => (
    <Link href={`/packages/${item.slug}`} key={item.slug}>
      <div className={`position-relative overflow-hidden rounded ${height} flex items-stretch`}>
        <Image
          src={item.primary_image}
          alt={item.title}
          width={400}
          height={300}
          className="rounded w-100 h-full object-cover transition-all duration-500 hover:scale-110 hover:brightness-90"
        />
        <div className="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent flex items-end p-4">
          <div>
            <h5 className="text-white text-center">{item.title}</h5>
            <h6 className="text-white text-center">{item.duration}</h6>
          </div>
        </div>
      </div>
    </Link>
  );

  return (
    <div className="deals-packages bg-gray-100 py-5">
      <div className="container">
        <h2 className="text-primary text-center mb-5">Deals You Can't Miss</h2>
        <div className="row row-cols-1 row-cols-md-3 g-4">

          {/* Column 1 */}
          <div className="col-lg-5">
            <div className="row g-4">
              {leftColumn[0] && (
                <div className="col-lg-12">
                  {renderCard(leftColumn[0])}
                </div>
              )}
              {leftColumn.slice(1).map((item: any) => (
                <div className="col-lg-6" key={item.slug}>
                  {renderCard(item)}
                </div>
              ))}
            </div>
          </div>

          {/* Column 2 */}
          <div className="col-lg-3">
            {middleColumn && renderCard(middleColumn, true, 'h-100')}
          </div>

          {/* Column 3 */}
          <div className="col-lg-4">
            <div className="row g-4">
              {rightColumn.map((item: any) => (
                <div className="col-lg-12" key={item.slug}>
                  {renderCard(item)}
                </div>
              ))}
            </div>
          </div>

        </div>
      </div>
    </div>
  );
}
