'use client';
import React, { useEffect } from 'react';
import Link from 'next/link';
import AOS from 'aos';
import 'aos/dist/aos.css';


interface SidebarProps {
  themes: string[];
  cities: string[];
  destinations: string[];
}

const Sidebar: React.FC<SidebarProps> = ({ themes, cities, destinations }) => {
  useEffect(() => {
    AOS.init({
      duration: 800,
      easing: 'ease-in-out',
      once: true,
    });
  }, []);

  return (
    <div className="sidebar-listing " data-aos="fade-right" data-aos-delay="100">
      <div className="mb-4 theme-section shadow-sm c-sec" data-aos="fade-up" data-aos-delay="200">
        <div className="d-flex align-items-center p-4  text-white">
          <img src="/images/icon-head-1.svg" alt="Theme Icon" className="icon" />
          <h6 className="ms-2 mb-0">Packages By Theme</h6>
        </div>
        <ul className="list-unstyled p-4">
          {themes.map((theme, index) => (
            <li key={index} className="mb-2" data-aos="fade-up" data-aos-delay={`${300 + index * 100}`}>
              <Link href={`#`} className="text-decoration-none text-dark hover-link">
                {theme}
              </Link>
            </li>
          ))}
        </ul>
      </div>

      <div className="mb-4 city-section c-sec" data-aos="fade-up" data-aos-delay="400">
        <div className="d-flex align-items-center p-4  text-white">
          <img src="/images/icon-head-1.svg" alt="City Icon" className="icon" />
          <h6 className="ms-2 mb-0">Packages from Top Cities</h6>
        </div>
        <ul className="list-unstyled p-4">
          {cities.map((city, index) => (
            <li key={index} className="mb-2" data-aos="fade-up" data-aos-delay={`${500 + index * 100}`}>
              <Link href={`/tour/${city.toLowerCase().replace(/\s+/g, '-')}`} className="text-decoration-none text-dark hover-link">
                {city}
              </Link>
            </li>
          ))}
        </ul>
      </div>

      <div className="destination-section c-sec" data-aos="fade-up" data-aos-delay="600">
        <div className="d-flex align-items-center p-4  text-white">
          <img src="/images/icon-head-1.svg" alt="Destination Icon" className="icon" />
          <h6 className="ms-2 mb-0">Popular Destinations</h6>
        </div>
        <ul className="list-unstyled p-4">
          {destinations.map((destination, index) => (
            <li key={index} className="mb-2" data-aos="fade-up" data-aos-delay={`${700 + index * 100}`}>
              <Link href={`/tour/${destination.toLowerCase().replace(/\s+/g, '-')}`} className="text-decoration-none text-dark hover-link">
                {destination}
              </Link>
            </li>
          ))}
        </ul>
      </div>
    </div>
  );
};

export default Sidebar;