'use client';
import { span } from 'framer-motion/client';
import React from 'react';

interface TourDetailsContentProps {
  tour: {
    title: string;

    duration: string;


  };
}

const TourDetailsContent: React.FC<any> = ({ tour }) => {
  return (
    <div className="tour-content">
      <h2 className="tour-title ">{tour.title} <span className="text-primary"> - {tour.details.duration_nights} Nights/ {tour.details.duration_days} Days</span></h2>
      
      {tour.details.route_details ? 
      <div className="tour-details d-flex align-items-=center gap-2">
        <img src="../location.svg" alt="icon" />
        <span className="days-count">{tour.details.route_details}</span>
      </div> : null}

      <div className="amenities py-4 ">
        <ul className="m-0 p-0 d-flex align-items-center justify-content-between">
          <li><span> <img src="../flight.svg" alt="icon" /> </span>Flight</li>
          <li><span> <img src="../hotel.svg" alt="icon" /> </span>Hotel</li>
          <li><span> <img src="../landscape.svg" alt="icon" /> </span>Sightseeing</li>
          <li><span> <img src="../car.svg" alt="icon" /> </span>Transport</li>
          <li><span> <img src="../meal.svg" alt="icon" /> </span>Meal</li>
        </ul>
      </div>

    </div>
  );
};

export default TourDetailsContent;
