'use client';
import React, { useEffect } from 'react';
import Image from "next/image";
import Link from 'next/link';
import AOS from 'aos';

import 'aos/dist/aos.css';

interface TourCardProps {
  slug: string;   
  title: string;
  rating: number;
  duration: string;
  tourTime: string;
  highlights: string[];
  imageUrl: string;
}

const TourCard: React.FC<TourCardProps> = ({ title, rating, duration, tourTime, highlights, imageUrl, slug }) => {
  const validImageUrl = imageUrl ? imageUrl : "/images/default.jpg";

  useEffect(() => {
    AOS.init({
      duration: 800,
      easing: 'ease-in-out',
      once: true,
    });
  }, []);

  return (
    <div className="tourCard mb-4 shadow-sm p-3 p-lg-4" data-aos="fade-up" data-aos-delay="100">
      <div className="row g-0">
        <div className="col-lg-3">
          {imageUrl && (
            <img
              src={validImageUrl}
              alt={title}
              className="w-100 h-48 object-cover "
              data-aos="zoom-in"
              data-aos-delay="200"
            />
          )}
        </div>
        <div className="col-lg-9">
          <div className="card-body px-lg-3 py-lg-2 pe-lg-0 mt-3 mt-lg-0">
            <div className="tour-wrapper">
              <div className="col-12 col-lg-8 ps-0">
                <div className="tour-info">
                  <h5 className="card-title mb-1" data-aos="fade-right" data-aos-delay="300">{title}</h5>
                  <p className="text-primary mb-0" data-aos="fade-right" data-aos-delay="400">
                    {'★'.repeat(rating) + '☆'.repeat(5 - rating)}
                  </p>
                  <div className="d-flex gap-5 text-muted small my-4" data-aos="fade-right" data-aos-delay="500">
                    <div className="d-flex align-items-center gap-1">
                      <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M11 5V11L15.5 15.5M20.75 11C20.75 13.5859 19.7228 16.0658 17.8943 17.8943C16.0658 19.7228 13.5859 20.75 11 20.75C8.41414 20.75 5.93419 19.7228 4.10571 17.8943C2.27723 16.0658 1.25 13.5859 1.25 11C1.25 8.41414 2.27723 5.93419 4.10571 4.10571C5.93419 2.27723 8.41414 1.25 11 1.25C13.5859 1.25 16.0658 2.27723 17.8943 4.10571C19.7228 5.93419 20.75 8.41414 20.75 11Z" stroke="#305CDE" />
                      </svg>
                      {duration ? 
                      <div className="d-flex flex-column ms-2">
                        <span className="fw-semibold text-black">Duration</span>
                        <span className="text-warning">{duration}</span>
                      </div> : null}
                    </div>
                    <div className="d-flex align-items-center gap-1">
                      <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.5 4H16.5V2.5C16.5 2.36739 16.4473 2.24021 16.3536 2.14645C16.2598 2.05268 16.1326 2 16 2C15.8674 2 15.7402 2.05268 15.6464 2.14645C15.5527 2.24021 15.5 2.36739 15.5 2.5V4H8.5V2.5C8.5 2.36739 8.44732 2.24021 8.35355 2.14645C8.25979 2.05268 8.13261 2 8 2C7.86739 2 7.74021 2.05268 7.64645 2.14645C7.55268 2.24021 7.5 2.36739 7.5 2.5V4H4.5C3.8372 4.00079 3.20178 4.26444 2.73311 4.73311C2.26444 5.20178 2.00079 5.8372 2 6.5V19.5C2.00079 20.1628 2.26444 20.7982 2.73311 21.2669C3.20178 21.7356 3.8372 21.9992 4.5 22H19.5C20.163 22 20.7989 21.7366 21.2678 21.2678C21.7366 20.7989 22 20.163 22 19.5V6.5C22 5.83696 21.7366 5.20107 21.2678 4.73223C20.7989 4.26339 20.163 4 19.5 4ZM21 19.5C21 19.8978 20.842 20.2794 20.5607 20.5607C20.2794 20.842 19.8978 21 19.5 21H4.5C4.10218 21 3.72064 20.842 3.43934 20.5607C3.15804 20.2794 3 19.8978 3 19.5V11H21V19.5ZM21 10H3V6.5C3 5.672 3.67 5 4.5 5H7.5V6.5C7.5 6.63261 7.55268 6.75979 7.64645 6.85355C7.74021 6.94732 7.86739 7 8 7C8.13261 7 8.25979 6.94732 8.35355 6.85355C8.44732 6.75979 8.5 6.63261 8.5 6.5V5H15.5V6.5C15.5 6.63261 15.5527 6.75979 15.6464 6.85355C15.7402 6.94732 15.8674 7 16 7C16.1326 7 16.2598 6.94732 16.3536 6.85355C16.4473 6.75979 16.5 6.63261 16.5 6.5V5H19.5C19.8978 5 20.2794 5.15804 20.5607 5.43934C20.842 5.72064 21 6.10218 21 6.5V10Z" fill="#305CDE" />
                      </svg>
                        {tourTime ?
                      <div className="d-flex flex-column ms-2">
                        <span className="fw-semibold text-black">Tour Time</span>
                        <span className="text-warning">{tourTime}</span>
                      </div> : null}

                    </div>
                  </div>
                </div>
              </div>
              <div className="col-12 col-lg-4">
                <div className="d-flex flex-lg-column align-items-end gap-3 gap-lg-2" data-aos="fade-left" data-aos-delay="600">
                  <div className="button">
                    <Link href="#" className="btn blue-btn" data-aos="zoom-in" data-aos-delay="700">
                      Enquire Now
                      <span>
                        <Image
                          width={23}
                          height={23}
                          sizes="100vw"
                          src="/images/button-arrow.png"
                          alt=""
                          className="ms-2"
                        />
                      </span>
                    </Link>
                  </div>
                  <div className="button">
                  
                    <Link href={`/packages/${slug}`} className="btn orange-btn" data-aos="zoom-in" data-aos-delay="800">
                      View Details
                      <span>
                        <Image
                          width={23}
                          height={23}
                          sizes="100vw"
                          src="/images/button-arrow.png"
                          alt=""
                          className="ms-2"
                        />
                      </span>
                    </Link>
                  </div>
                </div>
              </div>
            </div>
            {highlights ?
            <div className="mt-3" data-aos="fade-up" data-aos-delay="900">
              <h6 className="text-warning small mb-1">Tour Highlights</h6>
              {/* {highlights.map((highlight, index) => (
                <p key={index} className="list-group-item p-0 border-0 text-muted small m-0" data-aos="fade-up" data-aos-delay={`${1000 + index * 100}`}>
                  {highlights}
                </p>
              ))} */}
                <p className="list-group-item p-0 border-0 text-muted small m-0" data-aos="fade-up">
                  {highlights}
                </p>
              
            </div> : null}
          </div>
        </div>
      </div>
    </div>
  );
};

export default TourCard;
