"use client";

import React, { useEffect, useState } from "react";
import Image from "next/image";
import Link from "next/link";
import { useRouter } from "next/navigation";

const HeaderSec = ({ headerData }: any) => {
  const [selectedLang, setSelectedLang] = useState("EN");
  const [open, setOpen] = useState(false);
  const languages = ["EN", "FR", "ES", "BN"];
  const [menuOpen, setMenuOpen] = useState(false);
  const router = useRouter();

  const setUrl = (slug: any, displaySlug: any) => {
    router.push(`/packages/${slug}`);
  };

  const setUrlForList = (slug: any, displaySlug: any) => {
    router.push(`/india/${slug}`);
  };

  useEffect(() => {
    // Expose init function to global scope
    (window as any).googleTranslateElementInit = () => {
      new (window as any).google.translate.TranslateElement(
        { pageLanguage: "en" },
        "google_translate_element"
      );
    };

    // Dynamically load Google Translate script
    const addScript = document.createElement("script");
    addScript.src =
      "//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit";
    addScript.async = true;
    document.body.appendChild(addScript);

    // Cleanup (optional)
    return () => {
      document.body.removeChild(addScript);
    };
  }, []);

  return (
    <header>
      <div className="container">
        <div className="row">
          <div className="col-lg-3">
            <div className="logo-box">
              <Link href="/">
                <Image
                  width={300}
                  height={60}
                  sizes="100vw"
                  src="/images/logo.webp"
                  alt=""
                  className=""
                />
              </Link>
            </div>
          </div>
          <div className="col-lg-9">
            <div className="right-menu">
              <div className="top-sec">
                <ul>
                  <li>
                    <Link href="#">
                      <span>
                        <Image
                          width={16}
                          height={16}
                          sizes="100vw"
                          src="/images/call.png"
                          alt=""
                          className=""
                        />
                      </span>
                      Call Now: +91 431 4226100
                    </Link>
                  </li>

                  <li>
                    <div className="lang-dropdown" id="google_translate_element" />
                  </li>
                  {/* <li>
                    <div className="lang-dropdown">
                      <button
                        className="lang-btn"
                        onClick={() => setOpen(!open)}
                      >
                        <span>
                          <Image
                            width={13}
                            height={13}
                            sizes="100vw"
                            src="/images/glob.png"
                            alt=""
                            className=""
                          />
                        </span>
                        <span>{selectedLang}</span>
                        <span className={`arrow ${open ? "rotate" : ""}`}>
                          <Image
                            width={6}
                            height={4}
                            sizes="100vw"
                            src="/images/down-arrow.png"
                            alt=""
                            className=""
                          />
                        </span>
                      </button>

                      {open && (
                        <ul className="lang-options">
                          {languages.map((lang) => (
                            <li
                              key={lang}
                              onClick={() => {
                                setSelectedLang(lang);
                                setOpen(false);
                              }}
                            >
                              {lang}
                            </li>
                          ))}
                        </ul>
                      )}
                    </div>
                  </li> */}
                </ul>
              </div>
              <div className="main-menu">
                <nav className="navbar">
                  <button
                    className={`hamburger ${menuOpen ? "open" : ""}`}
                    onClick={() => setMenuOpen(!menuOpen)}
                    aria-label="Toggle menu"
                  >
                    <span className="bar top"></span>
                    <span className="bar middle"></span>
                    <span className="bar bottom"></span>
                  </button>

                  <ul className={`nav-links ${menuOpen ? "show" : ""}`}>
                    <li className="has-dropdown">
                      <Link href="#">
                        India
                        <span className="arrow">
                          <Image
                            width={8}
                            height={6}
                            sizes="100vw"
                            src="/images/main-menu-arrow.png"
                            alt=""
                            className=""
                          />
                        </span>
                      </Link>
                      <ul className="list-unstyled m-0 p-0">
                        {headerData.cities.map((cities: any) => (
                          <li key={cities.slug} className="has-dropdown">
                            {/* <button onClick={() =>
                                setUrlForList(cities.slug, cities.display_slug)
                              }
                            className="btn btn-link text-black text-decoration-none p-0">
                            {cities.name}
                            </button> */}
                            <Link href={`/india/${cities.slug}`}>
                              {" "}
                              {cities.name}
                            </Link>
                          </li>
                        ))}
                      </ul>
                    </li>

                    <li className="has-dropdown">
                      <Link href="/international-holidays">
                        World
                        {/* <span className="arrow">
                          <Image
                            width={8}
                            height={6}
                            sizes="100vw"
                            src="/images/main-menu-arrow.png"
                            alt=""
                            className=""
                          />
                        </span> */}
                      </Link>
                      {/* <ul>
                        <li>
                          <Link href="#">Europe</Link>
                        </li>
                        <li>
                          <Link href="#">Asia</Link>
                        </li>
                        <li>
                          <Link href="#">America</Link>
                        </li>
                      </ul> */}
                    </li>
                    <li className="has-dropdown">
                      <Link href="#">
                        Customized Holidays
                        <span className="arrow">
                          <Image
                            width={8}
                            height={6}
                            sizes="100vw"
                            src="/images/main-menu-arrow.png"
                            alt=""
                            className=""
                          />
                        </span>
                      </Link>
                      <ul>
                        {headerData.customized_packges.map((packages: any) => (
                          <li key={packages.slug}>
                            <Link href={`/packages/${packages.slug}`}>
                              {packages.title}
                            </Link>
                          </li>
                        ))}
                      </ul>
                      {/* <ul className="list-unstyled m-0 p-0"> 
                        {headerData.customized_packges.map((packages: any) => (
                          <li key={packages.slug} className="py-2 px-3 has-dropdown">
                            <button
                              onClick={() =>
                                setUrl(packages.slug, packages.display_slug)
                              }
                              className="btn btn-link text-black text-decoration-none p-0"
                            >
                              {packages.title}
                            </button>
                          </li>
                        ))}
                      </ul> */}
                    </li>
                    <li className="has-dropdown">
                      <Link href="#">
                        Car/Bus
                        <span className="arrow">
                          <Image
                            width={8}
                            height={6}
                            sizes="100vw"
                            src="/images/main-menu-arrow.png"
                            alt=""
                            className=""
                          />
                        </span>
                      </Link>
                      <ul>
                        <li>
                          <Link href="#">Car/Bus1</Link>
                        </li>
                        <li>
                          <Link href="#">Car/Bus2</Link>
                        </li>
                        <li>
                          <Link href="#">Car/Bus3</Link>
                        </li>
                      </ul>
                    </li>
                    <li className="has-dropdown">
                      <Link href="#">
                        Indian DMC
                        {/* <span className="arrow">
                          <Image
                            width={8}
                            height={6}
                            sizes="100vw"
                            src="/images/main-menu-arrow.png"
                            alt=""
                            className=""
                          />
                        </span> */}
                      </Link>
                      {/* <ul>
                        <li>
                          <Link href="#">Indian DMC 1</Link>
                        </li>
                        <li>
                          <Link href="#">Indian DMC 2</Link>
                        </li>
                        <li>
                          <Link href="#">Indian DMC 3</Link>
                        </li>
                      </ul> */}
                    </li>
                    <li>
                      <Link href="#">Contact Us</Link>
                    </li>
                  </ul>
                </nav>
              </div>
            </div>
          </div>
        </div>
      </div>
    </header>
  );
};

export default HeaderSec;
