// "use client";
import Banner from "@/app/components/common/banner";
import Breadcrumb from "@/app/components/common/Breadcrumb";
import ExpandableText from "@/app/components/common/ExpandableText";
import FAQAccordion from "@/app/components/common/FAQAccordion";
import FAQAccordionListing from "@/app/components/common/FAQAccordionForListing";
import TrainBanner from "@/app/components/luxury-trains/trainBanner";
import TrainExpandableText from "@/app/components/luxury-trains/trainExpandableText";
import TrainTabWithImages from "@/app/components/luxury-trains/traintabwithimages";
import { fetchTrainData } from "@/app/services/luxuryTrainService";
import { unstable_cache } from "next/cache";

export default async function LuxuryTrain() {
  const withCache = (fn: any, key: any, tags: any) =>
    unstable_cache(
      async () => {
        try {
          const result = await fn();
          return { data: result.data, error: null };
        } catch (error) {
          console.error(`Error in ${key}:`, error);
          return { data: null, error: `Failed to fetch ${key}` };
        }
      },
      [key],
      { revalidate: 5, tags }
    );

  const cachedTrainPageData = withCache(
    () => fetchTrainData(),
    `trainData_content`,
    [`trainData_content`]
  );

  const [trainData] = await Promise.all([cachedTrainPageData()]);

  const breadcrumbItems = [
    { label: "Home", href: "/" },
    { label: "Tour", href: "/" },
    { label: "Kashmir Tour Package", isCurrent: true },
  ];

  

  console.log("trainData", trainData);

  return (
    <div className="train-wrapper">
      <TrainBanner data={trainData.data.details.banner_image} />
      <div className="py-5" data-aos="fade-up" data-aos-delay="300">
        <div className="container">
          <Breadcrumb items={breadcrumbItems} />
          <TrainExpandableText
            title={trainData.data.details.title}
            text={trainData.data.details.description}
            collapsedLines={2}
          />
        </div>

        <TrainTabWithImages />

        <div className="faqs pb-5 pt-3">
          <div className="container">
            <FAQAccordion faqs={[]} />
          </div>
        </div>
      </div>
    </div>
  );
}
