// "use client";
import Breadcrumb from "@/app/components/common/Breadcrumb";
import Tourpackages from "@/app/components/internationalTourPackages/tourpackages";
import TravelPackages from "@/app/components/common/travelpackages";
import IntBanner from "@/app/components/internationalTourPackages/intBanner";
import IntExpandableText from "@/app/components/internationalTourPackages/intExpandableText";
import TabWithImages from "@/app/components/internationalTourPackages/tabwithimages";
import { fetchInternationalPageData } from "@/app/services/internationaltourService";
import { unstable_cache } from "next/cache";
import IntFaq from "@/app/components/internationalTourPackages/intFaq";

export default async function Page() {
  const withCache = (fn: any, key: any, tags: any) =>
    unstable_cache(
      async () => {
        try {
          const result = await fn();
          return { data: result.data, error: null };
        } catch (error) {
          console.error(`Error in ${key}:`, error);
          return { data: null, error: `Failed to fetch ${key}` };
        }
      },
      [key],
      { revalidate: 5, tags }
    );

  const cachedInternationslPageData = withCache(
    () => fetchInternationalPageData(),
    `internationalData_content`,
    [`internationalData_content`]
  );

  const [internationalData] = await Promise.all([
    cachedInternationslPageData(),
  ]);

  const breadcrumbItems = [
    { label: "Home", href: "/" },
    { label: "International Tour Packages", isCurrent: true },
  ];



  return (
    <div className="details-wrapper ">
      <IntBanner data={internationalData?.data?.details} />
      <div className="details-wrapper-inner">
        <div className="py-5" data-aos="fade-up" data-aos-delay="300">
          <div className="container">
            
            <Breadcrumb items={breadcrumbItems} />
            <IntExpandableText
              data={internationalData.data.details}
              collapsedLines={2}
            />
          </div>

          <TabWithImages internationalData={internationalData.data} />
          <TravelPackages internationalData={internationalData.data.deal_packages} />
          <Tourpackages internationalData={internationalData.data} />
          <div className="faqs pb-5 pt-3">
            <div className="container">
              <IntFaq faqs={internationalData?.data?.details?.faqs} />
            </div>
          </div>
        </div>
      </div>

    </div>
  );
}
