













// src/app/components/FooterDesktop.tsx (SERVER COMPONENT)

import Image from "next/image";
import Link from "next/link";

import {
  fetchHomeExclusiveData,
  trendingInternationalHomePackageData,
} from "../services/homeService";
import TripAdvisorWidget from "./TripAdvisorWisget";

const getTruncatedLabel = (label: string): string => {
  const words = label.trim().split(/\s+/);
  return words.length > 4 ? words.slice(0, 4).join(" ") + "..." : label;
};

export default async function FooterDesktopSec() {
  // Fetch data server-side
  const worldMenuData = await trendingInternationalHomePackageData();
  const indiaMenuData = await fetchHomeExclusiveData();

  const getWorldLinks = () =>
    worldMenuData?.data?.length
      ? worldMenuData.data.slice(0, 5).map((item: any) => ({
        label: getTruncatedLabel(item.title),
        href: `/packages/${item.slug}`,
        title: item.title,
      }))
      : [];

  const getIndiaLinks = () =>
    indiaMenuData?.data?.length
      ? indiaMenuData.data.slice(0, 5).map((item: any) => ({
        label: getTruncatedLabel(item.title),
        href: `/packages/${item.slug}`,
        title: item.title,
      }))
      : [];

  const aboutLinks = [
    { label: "About Us", href: "/about-us" },
    { label: "Our Team", href: "/our-team" },
    { label: "Our Partners", href: "/our-partners" },
    { label: "Our Credentials", href: "/credentials" },
    { label: "Indian DMC", href: "/indian-dmc" },
    { label: "Contact Us", href: "/contact-us" },
    { label: "CSR Policy", href: "/csr" },
    { label: "Awards & Achievements", href: "/awards-and-achievements" },
  ];

  const blogLinks = [
    { label: "Adventure", href: "https://www.cholantours.com/blog/adventure/" },
    { label: "Cultural", href: "https://www.cholantours.com/blog/cultural/" },
    { label: "Family Travel", href: "https://www.cholantours.com/blog/family-travel/" },
    { label: "Heritage", href: "https://www.cholantours.com/blog/heritage/" },
    { label: "Wildlife", href: "https://cholantours.com/blog/wildlife/" },
    { label: "Inspiration", href: "https://www.cholantours.com/blog/inspiration/" },
  ];

  const quickLinks = [
    { label: "India Tour Packages", href: "/india" },
    { label: "World Holiday Packages", href: "/international-holidays" },
    { label: "Customized Holidays", href: "/customized-holidays" },
    { label: "Car Rental", href: "/car-rental" },
    { label: "Privacy Policy", href: "/privacy-policy" },
    { label: "Terms & Conditions", href: "/terms-and-conditions" },
    { label: "Careers", href: "/careers" },
  ];

  const socialMedia = [
    { src: "/images/media1.webp", href: "https://www.facebook.com/CholanToursPrivateLimited/", alt: "Facebook" },
    { src: "/images/media2.webp", href: "https://x.com/cholantour", alt: "Twitter" },
    { src: "/images/media3.png", href: "https://in.linkedin.com/company/cholan-tours", alt: "LinkedIn" },
    { src: "/images/media5.png", href: "https://www.instagram.com/cholan_tours/", alt: "Instagram" },
  ];

  return (
    <footer>
      <div className="container">
        <div className="footer-wrapper">

          {/* Tabs */}
          <input type="radio" name="footer-tab" id="tab-about" defaultChecked hidden />
          <input type="radio" name="footer-tab" id="tab-international" hidden />
          <input type="radio" name="footer-tab" id="tab-india" hidden />
          <input type="radio" name="footer-tab" id="tab-blogs" hidden />

          <div className="footer-tabs">
            <button><label htmlFor="tab-about">About Cholan Tours</label></button>
            <button><label htmlFor="tab-international">International Tours</label></button>
            <button><label htmlFor="tab-india">India Tours</label></button>
            <button><label htmlFor="tab-blogs">Travel Blogs</label></button>
          </div>

          <div className="footer-content">
            <div className="footer-content-box">
              <div className="row gap-4 gap-md-0">

                {/* About / Description */}
                <div className="col-md-6 col-lg-3">
                  <div className="tab-content about-tab">
                    <div className="logo-box">
                      <div className="footer-logo">
                        <Image width={200} height={70} src="/images/logo-white-tagline.webp" alt="Cholan Tours Logo" />
                        <p>Cholan Tours is one of India's fast-growing ISO 9001:2015 quality-certified Destination Management Companies (DMC). Our services are approved by The Ministry of Tourism, Government of India.</p>
                      </div>
                       {/* <TripAdvisorWidget /> */}
                    </div>
                  </div>

                  <div className="tab-content international-tab">
                    <div className="logo-box">
                      <div className="footer-logo">
                        <Image width={250} height={70} src="/images/logo-white-tagline.webp" alt="Cholan Tours Logo" />
                        <p>Explore exciting international holiday packages with Cholan Tours, offering curated travel experiences to destinations worldwide.</p>
                      </div>
                       {/* <TripAdvisorWidget /> */}
                    </div>
                  </div>

                  <div className="tab-content india-tab">
                    <div className="logo-box">
                      <div className="footer-logo">
                        <Image width={250} height={70} src="/images/logo-white-tagline.webp" alt="Cholan Tours Logo" />
                        <p>Discover the beauty of India with our tailored holiday packages, from cultural tours to scenic getaways.</p>
                      </div>
                       {/* <TripAdvisorWidget /> */}

                    </div>
                  </div>

                  <div className="tab-content blogs-tab">
                    <div className="logo-box">
                      <div className="footer-logo">
                        <Image width={250} height={70} src="/images/logo-white-tagline.webp" alt="Cholan Tours Logo" />
                        <p>Read our travel blogs for inspiration, tips, and stories from destinations around the globe.</p>
                      </div>
                      {/* <TripAdvisorWidget /> */}

                    </div>
                   
                  </div>
                </div>

                {/* About Links */}
                <div className="col-md-6 col-lg-3">
                  <div className="footer-menu about-tab">
                    <h3>About Cholan Tours</h3>
                    <ul>{aboutLinks.map((link, i) => <li key={i}><Link href={link.href}>{link.label}</Link></li>)}</ul>
                  </div>

                  <div className="footer-menu international-tab">
                    <h3>International Tours</h3>
                    <ul>{getWorldLinks().map((link: any, i: any) => <li key={i}><Link href={link.href} title={link.title}>{link.label}</Link></li>)}</ul>
                  </div>

                  <div className="footer-menu india-tab">
                    <h3>India Tours</h3>
                    <ul>{getIndiaLinks().map((link: any, i: any) => <li key={i}><Link href={link.href} title={link.title}>{link.label}</Link></li>)}</ul>
                  </div>

                  <div className="footer-menu blogs-tab">
                    <h3>Travel Blogs</h3>
                    <ul>{blogLinks.map((link, i) => <li key={i}><a href={link.href} target="_blank" rel="noopener noreferrer">{link.label}</a></li>)}</ul>
                  </div>
                </div>

                {/* Quick Links */}
                <div className="col-md-6 col-lg-3">
                  <div className="footer-menu">
                    <h3>Quick Links</h3>
                    <ul>{quickLinks.map((link, i) => <li key={i}><Link href={link.href}>{link.label}</Link></li>)}</ul>
                  </div>
                </div>

                {/* Contact */}
                <div className="col-md-6 col-lg-3">
                  <div className="footer-contact">
                    <h3>Contact Us</h3>
                    <ul>
                      <li><Link href="tel:+91 431 4226100"><span>
                        <Image
                          width={20}
                          height={20}
                          sizes="100vw"
                          src="/images/call-two.png"
                          alt=""
                        />
                      </span>+91 431 4226100</Link></li>
                      <li><Link href="mailto:enquiry@cholantours.com"> <span>
                        <Image
                          width={20}
                          height={20}
                          sizes="100vw"
                          className="pt-1"
                          src="/images/mgg.png"
                          alt=""
                        />
                      </span>enquiry@cholantours.com</Link> <p>CIN: U31100TN2010PTC078389</p></li>
                      <li> <span>
                        <Image
                          width={20}
                          height={20}
                          sizes="100vw"
                          src="/images/address.png"
                          alt=""
                        />
                      </span>No 4, Annai Avenue, Srirangam, Trichy, Tamil Nadu 620006, India.</li>
                    </ul>
                  </div>
                   
                </div>

              </div>
            </div>
          </div>
        </div>

        {/* Social */}
        <div className="footer-media">
          <h5>Follow us on</h5>
          <ul>
            {socialMedia.map((media, i) => (
              <li key={i}>
                <Link href={media.href} target="_blank">
                  <Image width={12} height={12} src={media.src} alt={media.alt} />
                </Link>
              </li>
            ))}
          </ul>
        </div>

        <div className="copyright-sec">
          <p>© {new Date().getFullYear()} Cholan Tours. All Rights Reserved.</p>
        </div>
      </div>
    </footer>
  );
}
