<?php
// Import PHPMailer classes into the global namespace 
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

// Include library files 
require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';


function log_folder_create($path)
{
	if (!file_exists($path)) {
		mkdir($path, 0775, true);
	}
}

function file_path_check($path)
{
	$output = shell_exec("cat $path");
	return $output;
}

function gateway_tank_check($gateway)
{
	$db = new Database();
	$tank_query = "SELECT tm.tank_name, tm.id AS tank_id FROM `tank_masters` AS tm INNER JOIN `tank_gateway_mappings` AS tgm ON tm.id = tgm.tank_id WHERE tgm.`gateway_no` =" . $gateway;
	if ($tankdata = $db->executeQuery($tank_query)) {
		$tankrow = $tankdata->fetch_assoc();
		$tankname = strtolower(str_replace(' ', '', $tankrow['tank_name']));
		$tankrow['reading_table'] = 'tank_' . $tankname . '_' . $tankrow['tank_id'];
		return $tankrow;
	} else {
		return 'no_tank';
	}
}

function find_between_dollars($str)
{
	$pos1 = strpos($str, '$'); // find the first $
	$pos2 = strpos($str, '$', $pos1 + 1); // find the second $, starting from the position of the first $
	if ($pos2 !== false) {
		return substr($str, $pos1 + 1, $pos2 - $pos1 - 1); // extract the value
	} else {
		return 'error'; // or throw an error, depending on your requirements
	}
}

function get_Water_Fe_ratio($oprVal, $kelvinTemp)
{
	// Constants
	$R = 8.314; // J/(mol·K)
	$F = 96485; // C/mol
	$n = 1; // For Fe³⁺/Fe²⁺
	$E_standard = 0.77; // Standard potential (E°) in Volts
	//$kelvinTemp = 32 + 273.15;

	// Input values
	//$E_measured = 0.5; // Measured ORP (E) in Volts
	$E_measured = $oprVal / 1000;
	//$T = 298; // Temperature in Kelvin (25°C)
	$T = $kelvinTemp;

	$num_cal = $n * $F * ($E_standard - $E_measured);


	$num = ($num_cal < 0) ? ($num_cal * (-1)) : $num_cal;

	// Calculate the ratio [Fe²⁺]/[Fe³⁺] using the Nernst equation
	$Fe_ratio = $num / ($R * $T);
	//$ratio = exp($ln_ratio);

	$Fe2 = 0.35 / (1 + (1 / $Fe_ratio));
	//$Fe_ratio = round($ratio, 8);
	//$Fe_ratio = sprintf("%.8f", $ratio);
	// Output the result
	$Fe2val = sprintf("%.8f", $Fe2);
	//echo "The ratio of Fe²⁺ to Fe³⁺ is approximately " . round($ratio, 2) . ":1\n";
	return $Fe2val;
}


function check_tank_data($tank_data)
{
	$mail = new PHPMailer(true);
	$db = new Database();
	$readtime =  date('d-m-Y H:i:s');
	$whmQuery = "SELECT `param_name`, `param_max_value`, `param_min_value` FROM `water_health_measures` WHERE is_deleted = 0";
	if ($whmdata = $db->executeQuery($whmQuery)) {
		$whmrow = $whmdata->fetch_all(MYSQLI_ASSOC);
		$alertMsg = "Tank : " . $tank_data['tank_name'] . " is having";
		$subMsg = "";
		foreach ($whmrow as $whm) {
			if ($whm['param_name'] == 'CL') {
				if ($tank_data['CL'] > $whm['param_max_value']) {
					$subMsg .=  " chloride level " . $tank_data['CL'] . " mg/L at " . $readtime . " more than maximum level [" . $whm['param_max_value'] . " mg/L - " . $whm['param_min_value'] . " mg/L],";
				} else if ($tank_data['CL'] < $whm['param_min_value']) {
					$subMsg .= " chloride level " . $tank_data['CL'] . " mg/L at " . $readtime . " less than mimimum level [" . $whm['param_max_value'] . " mg/L - " . $whm['param_min_value'] . " mg/L],";
				}
			} elseif ($whm['param_name'] == 'TDS') {
				if ($tank_data['TDS'] > $whm['param_max_value']) {
					$subMsg .= " TDS level " . $tank_data['TDS'] . " mg/L at " . $readtime . " more than maximum level [" . $whm['param_max_value'] . " mg/L - " . $whm['param_min_value'] . " mg/L], ";
				} else if ($tank_data['TDS'] < $whm['param_min_value']) {
					$subMsg .= " TDS level " . $tank_data['TDS'] . " mg/L at " . $readtime . " less than mimimum level [" . $whm['param_max_value'] . " mg/L - " . $whm['param_min_value'] . " mg/L], ";
				}
			} elseif ($whm['param_name'] == 'PH') {
				if ($tank_data['PH'] > $whm['param_max_value']) {
					$subMsg .= " PH level " . $tank_data['PH'] . " at " . $readtime . " more than maximum level [" . $whm['param_max_value'] . " - " . $whm['param_min_value'] . "],";
				} else if ($tank_data['TDS'] < $whm['param_min_value']) {
					$subMsg .= " PH level " . $tank_data['PH'] . " at " . $readtime . " less than mimimum level [" . $whm['param_max_value'] . " - " . $whm['param_min_value'] . "], ";
				}
			} elseif ($whm['param_name'] == 'TUR') {
				if ($tank_data['TUR'] > $whm['param_max_value']) {
					$subMsg .= " Turbidity level " . $tank_data['TUR'] . " NTU at " . $readtime . " more than maximum level [" . $whm['param_max_value'] . " NTU - " . $whm['param_min_value'] . " NTU], ";
				} else if ($tank_data['TUR'] < $whm['param_min_value']) {
					$subMsg .= " Turbidity level " . $tank_data['TUR'] . " NTU at " . $readtime . " less than mimimum level [" . $whm['param_max_value'] . " NTU - " . $whm['param_min_value'] . " NTU], ";
				}
			} elseif ($whm['param_name'] == 'FE' && $tank_data['FE'] != 'NULL') {
				if ($tank_data['FE'] > $whm['param_max_value']) {
					$subMsg .= " iron level " . $tank_data['FE'] . " mg/L at " . $readtime . " more than maximum level [" . $whm['param_max_value'] . " mg/L - " . $whm['param_min_value'] . " mg/L], ";
				} else if ($tank_data['FE'] < $whm['param_min_value']) {
					$subMsg .= " Iron level " . $tank_data['FE'] . " mg/L at " . $readtime . " less than mimimum level [" . $whm['param_max_value'] . " mg/L - " . $whm['param_min_value'] . " mg/L], ";
				}
			}
		}
		$alertMsg = $alertMsg . $subMsg . " in the water.";
		/*
		if ($subMsg != '') {
			//$mail->SMTPDebug = 3;
			$mail->isSMTP();
			$mail->Host = 'mail.authsmtp.com'; // Your SMTP server 
			$mail->SMTPAuth = true;
			$mail->Username = 'ac74659'; // Your SMTP username
			$mail->Password = 'Tcbprocessing21!'; // Your SMTP password
			$mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
			$mail->Port = 2525;

			$mail->setFrom('reservation@mbshotels.com', 'Water Tank Monitoring System');
			//$mail->addAddress('name@domain.com', 'User');     // Add a recipient
			$mail->addAddress('subhodeep.goswami@maxbridgesolution.com');     // Name is optional
			$mail->addAddress('tanmoy.chakraborty@maxbridgesolution.com');     // Name is optional
			//$mail->addReplyTo('info@wtms.net', 'Water Tank Monitoring System');
			$mail->addCC('u.nandy1992@gmail.com');
			$mail->addBCC('arijit.pal@maxbridgesolution.com');

			//$mail->addAttachment('');         // Add attachments
			//$mail->addAttachment('/tmp/image.jpg', 'new.jpg');    // Optional name
			$mail->isHTML(true);                                  // Set email format to HTML

			$mail->Subject = "Tank: " . $tank_data['tank_name'] . " Data Error";
			$mail->Body    = $alertMsg;
			//$mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

			if (!$mail->send()) {
				//echo 'Message could not be sent.';
				echo 'Mailer Error: ' . $mail->ErrorInfo;
			} else {
				//echo 'Message has been sent';
			}
		}*/
	}
}
