

<?php $__env->startSection('content'); ?>
<main class="content">
    <div class="g-color"></div>
    <div class="table-header position-relative">

        <div class="row justify-content-between">
            <form class="hd-date-input mt-5" action="<?php echo e(route('watervsturbChartReport')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="col-md-12">
                    <ul class="d-flex align-items-center p-0">
                        <li class="">
                            <div class="date-input d-flex align-items-center position-relative"><b class="me-3">Date
                                    From:</b>
                                <input class="form-control w-50" type="text" name="fromdate"
                                    value="<?php echo date('d-m-Y', strtotime($from_date)); ?>" id="device_purchased_on"
                                    autocomplete="off">
                                <i class="ri-calendar-2-line"></i>
                            </div>
                        </li>
                        <li class="">
                            <div class=" date-input d-flex align-items-center position-relative"><b class="me-2">To
                                    :</b>
                                <input class="form-control w-75" type="text" name="todate"
                                    value="<?php echo date('d-m-Y', strtotime($to_date)); ?>" id="device_purchased_on1"
                                    autocomplete="off">
                                <i class="ri-calendar-2-line"></i>
                            </div>
                        </li>
                        <li class="">
                            <div class="d-flex align-items-center position-relative"><b class="me-3">Select Tank:</b>
                                <select class="form-select w-75" name="tank_list" id="tank_list"
                                    aria-label="Default select example">
                                    <option value="">Select Tank</option>
                                    <?php $__currentLoopData = $tanks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tank->id); ?>" <?php if ($tname == $tank->id) { ?> Selected
                                        <?php } ?>><?php echo e($tank->tank_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <input type="hidden" name="sval" value="1" />
                            </div>
                        </li>
                        <li class="">
                            <div class="btn-sec m-2">
                                <button type="submit" class="btn btn-primary"
                                    onClick="return validation();">Submit</button>
                            </div>
                        </li>
                    </ul>
                </div>
            </form>
        </div>
    </div>
    <div class="position-relative">
        <div class="container-sec">
            <div class="cotainer-body p-4">
                <div class="page-hading">
                    <div class="d-flex align-items-center position-relative d-sm-block d-md-flex">
                        <h2>Water Level vs Turbidity</h2>
                        <div class="detasheet-graph-icon ms-auto">
                            <a href="javascript:history.back()"" class="">Graph</a>
                            <a href=" #" class="active">Datasheet</a>
                        </div>
                        <form method="get" action="<?php echo e(route('watervsturbExcel', $encdata)); ?>">
                            <button class="btn download-btn ms-2"><i class="ri-folder-download-fill"></i>
                                Download</button>
                        </form>
                    </div>
                </div>

                <div class="tank-wise-sec">
                    <h2 class="mt-3 mb-3 align-items-center d-flex"><i class="ri-calendar-2-line me-2"
                            style="font-size: 24px; font-weight: 100;"></i> From:
                        <?php echo e(date('d-m-Y', strtotime($from_date))); ?> To: <?php echo e(date('d-m-Y', strtotime($to_date))); ?>

                    </h2>
                    <?php // echo "<pre>"; print_r($data); 
                    ?>
                    <!-- water level table -->
                    <div class="row">
                        <h2>Water Level vs Turbidity</h2>
                        <div class="table-ar table-responsive">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th scope="col" style="text-align: left;">Date </th>
                                        <th scope="col">Water Level(Ft) </th>
                                        <th scope="col">Turbidity (NTU)</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td style="text-align: left;">
                                            <?php echo e(\Carbon\Carbon::parse($row->read_date)->format("d-m-Y ")); ?><?php echo e($row->read_hour.':00'); ?>

                                        </td>
                                        <td><?php echo number_format((float)($row->wtrval), 2); ?> </td>
                                        <td><?php echo number_format((float)($row->turval), 2); ?> </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- <footer class="footer">
          <small style="margin-bottom: 20px; display: inline-block">
            © 2022 made with
            <span style="color: red; font-size: 18px">&#10084;</span> by -
            <a target="_blank" href="#"> Mohamed Azouaoui </a>
          </small>
          <br />
          <div>
            <a href="#" target="_blank" rel="noopener noreferrer">
              <img alt="GitHub followers" src="#" />
            </a>
            <a href="#" target="_blank" rel="noopener noreferrer">
              <img alt="Twitter Follow" src="#" />
            </a>
          </div>
        </footer> -->
</main>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
$(function() {
    $("#device_purchased_on").datepicker({
        dateFormat: 'dd-mm-yy' // Example format
    });
});

$(function() {
    $("#device_purchased_on1").datepicker({
        dateFormat: 'dd-mm-yy' // Example format
    });
});
</script>
<?php $__env->stopPush(); ?>

<script>
function validation() {
    if (document.getElementById('device_purchased_on').value == "") {
        $('#error-fdt').html('* From Date Is Required');
        $('#error-fdt').css('color', 'red');
        $('#device_purchased_on').focus();
        return false;
    }
    if (document.getElementById('device_purchased_on1').value == "") {
        $('#error-tdt').html('* To Date Is Required');
        $('#error-tdt').css('color', 'red');
        $('#device_purchased_on1').focus();
        return false;
    }

    if (document.getElementById('tank_list').value == "") {
        $('#error-tl').html('* Select A Tank');
        $('#error-tl').css('color', 'red');
        $('#tank_list').focus();
        return false;
    }

    return true;
}
</script>

</body>

</html>
<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/asansolphe/production/resources/views/report/watervsturbreport.blade.php ENDPATH**/ ?>