@extends('layouts.main')


@section('content')
<main class="content">
    <div class="g-color"></div>
    <div class="position-relative">
        <div class="container-sec">
            <div class="cotainer-body p-4">
                <div class="page-hading">
                    <a href="#" class="d-flex align-items-center">
                        <i class="ri-arrow-left-line"></i> Edit User
                    </a>
                </div>
                <div class="edit-user">

                    <form action="{{ route('users.update', $user->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
						<?php // dd($user); ?>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label" for="name"><b>Name</b></label>
                                    <input type="text" name="name" class="form-control" value="{{ $user->name }}" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label" for="email"><b>Email</b></label>
                                    <input type="email" name="email" class="form-control" value="{{ $user->email }}" readonly="" required>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label" for="role">Role</label>
                                    <select name="roles" class="form-control"  readonly="">
                                        @foreach ($roles as $value => $label)
                                        <option value="{{ $value }}" {{ isset($userRole[$value]) ? 'selected' : ''}}>
                                            {{ $label }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="password">Password</label>
                                    <input type="password" name="password" class="form-control" id="password">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label" for="password_confirmation">Confirm Password</label>
                                    <input type="password" name="password_confirmation" class="form-control" id="password_confirmation">
                                </div>
                            </div>
                        </div>
						<div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <strong>Tank List:</strong>
									<?php  $tanks_id = json_decode($user->tank_ids); ?>
                                    <br />
                                    @foreach($tanks as $row)
                                    <label><input type="checkbox" name="tank_ids[]" value="{{$row->id}}" <?php if (in_array($row->id, $tanks_id)){ ?> checked="checked" <?php } ?>  class="name">
                                        {{ $row->tank_name }}</label>
                                    <br />
                                    @endforeach
                                </div>
                            </div>                            
                        </div>
                        <div class="row p-5">
                            <div class="btn-footer">
                                <div class="btn-sec m-2">
                                    <button type="submit" class="btn btn-primary">Save</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</main>

@endsection




<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/jquery.validation/1.19.3/jquery.validate.min.js"></script>
