@extends('layouts.main')

@section('content')
<main class="content">
  <div class="g-color"></div>
  <div class="table-header position-relative">
    <div class="row justify-content-between ">
      <div class="col-md-4">
        <ul class="row align-items-center p-0">
          <li class="col"><b>Date :</b>04/09/2024</li>
          <li class="col"><b>Last Phased :</b>12:00 PM</li>
          <!-- <li class="col-6">
                  <div class="d-flex align-items-center position-relative"><b class="me-2">Search Tank :</b>
                    <div class="serach-ar d-flex align-items-center">
                      <input class="form-control" type="search" placeholder="Search" aria-label="Search">
                      <button class="search-icon" type="submit"><i class="ri-search-2-line"></i></button>
                    </div>
                  </div>
                </li> -->
        </ul>
      </div>

    </div>
    <div class="row justify-content-between">
      <div class="col-md-6">
        <ul class="d-flex align-items-center p-0">
          <li class="">
            <div class="d-flex align-items-center position-relative"><b class="me-3">Date Range:</b>
              <input class="form-control w-50" type="date">
            </div>
          </li>
          <li class="">
            <div class="d-flex align-items-center position-relative"><b class="me-2">To :</b>
              <input class="form-control w-75" type="date" placeholder="Search" aria-label="Search">
            </div>
          </li>
        </ul>
      </div>
      <div class="col-md-3">
        <div class="d-flex align-items-center justify-content-end">
          <span class="me-2 text-white">Select Tank:</span>
          <select class="form-select w-25" aria-label="Default select example">
            <option selected>10</option>
            <option value="1">One</option>
            <option value="2">Two</option>
            <option value="3">Three</option>
          </select>
        </div>
      </div>
    </div>
  </div>
  <div class="position-relative">
    <div class="container-sec">
      <div class="cotainer-body p-4">
        <div class="page-hading">
          <div class="d-flex align-items-center justify-content-between">
            <div class="d-flex align-items-center position-relative">
              <a href="{{ route('tankdetails') }}" class="d-flex align-items-center me-4 mb-0">
                <i class="ri-arrow-left-line"></i>Tank 1
              </a>
              <div class="swich-btn">
                <div class="switches-container">
                  <input type="radio" id="switchDatasheet" name="switchPlan" value="Datasheet"
                    checked="checked" />
                  <input type="radio" id="switchGraph" name="switchPlan" value="Graph" />
                  <label for="switchDatasheet">Datasheet</label>
                  <label for="switchGraph">Graph</label>
                  <div class="switch-wrapper">
                    <div class="switch">
                      <div>Datasheet</div>
                      <div>Graph</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="tank-wise-sec">
          <h2 class="mt-3 mb-3 align-items-center d-flex"><i class="ri-calendar-2-line me-2"
              style="font-size: 24px; font-weight: 100;"></i> Tank
            1</h2>
          <div class="row">
            <div class="table-ar">
              <table class="table table-striped table-bordered">
                <thead>
                  <tr>
                    <th scope="col" style="text-align: left;">Time </th>
                    <th scope="col">pH Level </th>
                    <th scope="col">Turbidity Level (NTU)</th>
                    <th scope="col">Chlorine Level (mg/L)</th>
                    <th scope="col">TDS Level(ppm) </th>
                    <th scope="col">Water Level (mtr) </th>
                    <th scope="col">Iron Level (mg/L) </th>


                  </tr>
                </thead>
                <tbody>
                  @foreach ($data as $reading)
                  <tr>
                    <td style="text-align: left;">{{ \Carbon\Carbon::parse($reading->read_date)->format('d/m/Y'). \Carbon\Carbon::createFromTime($reading->read_hour)->format(' g a') }}</td>
                    <td>{{$reading->phval}}</td>
                    <td>{{$reading->turval}}</td>
                    <td>{{$reading->clval}}</td>
                    <td>{{$reading->tdsval}}</td>
                    <td>{{$reading->wtrval}}</td>
                    <td>{{$reading->oprval}}</td>

                  </tr>
                  @endforeach

                </tbody>
              </table>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>

  <!-- <footer class="footer">
          <small style="margin-bottom: 20px; display: inline-block">
            © 2022 made with
            <span style="color: red; font-size: 18px">&#10084;</span> by -
            <a target="_blank" href="#"> Mohamed Azouaoui </a>
          </small>
          <br />
          <div>
            <a href="#" target="_blank" rel="noopener noreferrer">
              <img alt="GitHub followers" src="#" />
            </a>
            <a href="#" target="_blank" rel="noopener noreferrer">
              <img alt="Twitter Follow" src="#" />
            </a>
          </div>
        </footer> -->
</main>
@endsection
</body>

</html>