@extends('layouts.main')

@section('content')
<main class="content">
    <div class="g-color"></div>
    <div class="table-header position-relative">
        <div class="row justify-content-between ">
        </div>
        <div class="row justify-content-between">
            <form class="hd-date-input mt-5" action="{{ route('tankwiseChartReport') }}" method="post">
                @csrf
                <div class="col-md-12">
                    <ul class="d-flex align-items-center p-0">
                        <li class="">
                            <div class="date-input d-flex align-items-center position-relative"><b class="me-3">Date
                                    From:</b>
                                     <span class="date-inputbox position-relative w-50">
                                        <input class="form-control" type="text" name="fromdate"
                                            value="<?php if($fdate == ""){ echo ""; }else{ echo date('d-m-Y',strtotime($fdate)); } ?>"
                                            id="device_purchased_on" autocomplete="off">
                                        <i class="ri-calendar-2-line"></i>
                                    <span>
                            </div>
                        </li>
                        <li class="">
                            <div class=" date-input d-flex align-items-center position-relative"><b class="me-2">To
                                    :</b>
                                     <span class="date-inputbox position-relative w-75">
                                <input class="form-control" type="text" name="todate"
                                    value="<?php if($fdate == ""){ echo ""; }else{ echo date('d-m-Y',strtotime($tdate)); } ?>"
                                    id="device_purchased_on1" autocomplete="off">
                                <i class="ri-calendar-2-line"></i>
                            </span>
                            </div>
                        </li>
                        <li class="">
                            <div class="d-flex align-items-center position-relative"><b class="me-3">Select Tank:</b>
                                <select class="form-select w-75" name="tank_list" id="tank_list"
                                    aria-label="Default select example">
                                    <option value="">Select Tank</option>
                                    @foreach ($tanks as $tank)
                                    <option value="{{ $tank->id }}" <?php if ($tname == $tank->id){ ?> Selected
                                        <?php } ?>>{{ $tank->tank_name }}</option>
                                    @endforeach
                                </select>
                                <input type="hidden" name="sval" value="1" />
                            </div>
                        </li>
                        <li class="">
                            <div class="btn-sec m-2">
                                <button type="submit" class="btn btn-primary"
                                    onClick="return validation();">Submit</button>
                            </div>
                        </li>
                    </ul>
                </div>
            </form>
        </div>
    </div>
    <div class="position-relative">
        <div class="container-sec">
            <div class="cotainer-body p-4">
                <div class="page-hading">
                    <div class="d-flex align-items-center justify-content-between d-sm-block d-md-flex">
                        <h2>Compliance Report</h2>
                    </div>
                </div>
                <div class="row row-spacing">
                    <div class="col-md-12">&nbsp;</div>
                </div>
                <?php // echo "<pre>"; print_r($phReadings);  die; ?>

                <div class="add-tank">
                    <div class="row">
                        <div class="col-md-12">
                            <div id="container"></div>
                        </div>
                    </div>
                    <div class="row row-spacing">
                        <div class="col-md-12">&nbsp;</div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div id="containeropr"></div>
                        </div>
                    </div>
                    <div class="row row-spacing">
                        <div class="col-md-12">&nbsp;</div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div id="containerchlrn"></div>
                        </div>
                    </div>
                    <div class="row row-spacing">
                        <div class="col-md-12">&nbsp;</div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div id="containertds"></div>
                        </div>
                    </div>
                    <div class="row row-spacing">
                        <div class="col-md-12">&nbsp;</div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div id="containertur"></div>
                        </div>
                    </div>
                    <div class="row row-spacing">
                        <div class="col-md-12">&nbsp;</div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div id="containerwater_lvl"></div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>


</main>

@endsection

<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/accessibility.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
			// Set locale options
		Highcharts.setOptions({
			lang: {
				decimalPoint: '.',
				thousandsSep: ','
			}
		});
    // Use the PHP variables passed from the controller
    let categories = @json($categories);
    let data = @json($data);

    // Threshold values from PHP
    const maxThreshold = <?php echo $measures['PH']->param_max_value; ?>;
    const minThreshold = <?php echo $measures['PH']->param_min_value; ?>;

    // Function to format the date for X-axis
    function formatDate(category) {
        let parts = category.split('-');
        if (parts.length === 3) {
            // Y-m-d format, convert to d-m-Y
            return `${parts[2]}-${parts[1]}-${parts[0]}`;
        } else if (parts.length === 2) {
            // Y-m format, convert to Y-M (month name)
            const date = new Date(category + '-01');
            const monthName = date.toLocaleString('default', {
                month: 'short'
            });
            return `${parts[0]}-${monthName}`;
        }
        return category; // Return as is for other cases
    }

    // Apply the formatting function to the categories
    let formattedCategories = categories.map(formatDate);

    // Create an array to hold the colored data points
    let coloredData = data.map(function(value) {
        let color;

        // Check the value against the threshold values and assign a color
        if (value > maxThreshold || value < minThreshold) {
            color = 'red'; // If value is out of the threshold range, make it red
        } else {
            color = 'green'; // Otherwise, make it green
        }

        // Return the value along with its associated color
        return {
            y: value,
            color: color
        };
    });

    // Create the Highcharts chart
    Highcharts.chart('container', {
        chart: {
            type: 'column'
        },
        title: {
            text: 'Average pH Levels'
        },
        credits: {
            enabled: false
        },
        xAxis: {
            categories: formattedCategories, // Use the formatted categories
            title: {
                text: 'Period'
            }
        },
        yAxis: {
            title: {
                text: 'Average pH Level'
            },
            plotLines: [{ // High alert threshold
                    value: maxThreshold,
                    color: 'blue',
                    dashStyle: 'shortdash',
                    width: 2,
                    label: {
                        text: `High Threshold (${maxThreshold})`
                    },
                    zIndex: 5 // Make sure the line appears in front of the bars
                },
                { // Low alert threshold
                    value: minThreshold,
                    color: 'orange',
                    dashStyle: 'shortdash',
                    width: 2,
                    label: {
                        text: `Low Threshold (${minThreshold})`
                    },
                    zIndex: 5 // Make sure the line appears in front of the bars
                }
            ]
        },
        series: [{
            name: 'Average pH',
            data: coloredData, // Y-axis data points with color
            showInLegend: false
        }]
    });
});
//-----------------------opr--------------------------------
document.addEventListener('DOMContentLoaded', function() {
			// Set locale options
		Highcharts.setOptions({
			lang: {
				decimalPoint: '.',
				thousandsSep: ','
			}
		});
    // Use the PHP variables passed from the controller
    let categories = @json($oprcategories);
    let data = @json($oprdata);

    // Threshold values from PHP
    const maxThreshold = <?php echo $measures['FE']->param_max_value; ?>;
    const minThreshold = <?php echo $measures['FE']->param_min_value; ?>;

    // Function to format the date for X-axis
    function formatDate(category) {
        let parts = category.split('-');
        if (parts.length === 3) {
            // Y-m-d format, convert to d-m-Y
            return `${parts[2]}-${parts[1]}-${parts[0]}`;
        } else if (parts.length === 2) {
            // Y-m format, convert to Y-M (month name)
            const date = new Date(category + '-01');
            const monthName = date.toLocaleString('default', {
                month: 'short'
            });
            return `${parts[0]}-${monthName}`;
        }
        return category; // Return as is for other cases
    }

    // Apply the formatting function to the categories
    let formattedCategories = categories.map(formatDate);

    // Create an array to hold the colored data points
    let coloredData = data.map(function(value) {
        let color;

        // Check the value against the threshold values and assign a color
        if (value > maxThreshold || value < minThreshold) {
            color = 'red'; // If value is out of the threshold range, make it red
        } else {
            color = 'green'; // Otherwise, make it green
        }

        // Return the value along with its associated color
        return {
            y: value,
            color: color
        };
    });

    // Create the Highcharts chart
    Highcharts.chart('containeropr', {
        chart: {
            type: 'column'
        },
        title: {
            text: 'Average Iron Levels'
        },
        credits: {
            enabled: false
        },
        xAxis: {
            categories: formattedCategories, // Period labels for X-axis
            title: {
                text: 'Period'
            }
        },
        yAxis: {
            title: {
                text: 'Average Iron Level'
            },
            plotLines: [{ // High alert threshold
                    value: maxThreshold,
                    color: 'blue',
                    dashStyle: 'shortdash',
                    width: 2,
                    label: {
                        text: `High Threshold (${maxThreshold})`
                    },
                    zIndex: 5 // Make sure the line appears in front of the bars
                },
                { // Low alert threshold
                    value: minThreshold,
                    color: 'orange',
                    dashStyle: 'shortdash',
                    width: 2,
                    label: {
                        text: `Low Threshold (${minThreshold})`
                    },
                    zIndex: 5 // Make sure the line appears in front of the bars
                }
            ]
        },
        series: [{
            name: 'Average Iron',
            data: coloredData, // Y-axis data points with dynamic colors
            showInLegend: false
        }]
    });
});
//-----------------------chlorin--------------------------------
document.addEventListener('DOMContentLoaded', function() {
			// Set locale options
		Highcharts.setOptions({
			lang: {
				decimalPoint: '.',
				thousandsSep: ','
			}
		});
    // Use the PHP variables passed from the controller
    let categories = @json($chlrncategories);
    let data = @json($chlrndata);

    // Threshold values from PHP
    const maxThreshold = <?php echo $measures['CL']->param_max_value; ?>;
    const minThreshold = <?php echo $measures['CL']->param_min_value; ?>;

    // Function to format the date for X-axis
    function formatDate(category) {
        let parts = category.split('-');
        if (parts.length === 3) {
            // Y-m-d format, convert to d-m-Y
            return `${parts[2]}-${parts[1]}-${parts[0]}`;
        } else if (parts.length === 2) {
            // Y-m format, convert to Y-M (month name)
            const date = new Date(category + '-01');
            const monthName = date.toLocaleString('default', {
                month: 'short'
            });
            return `${parts[0]}-${monthName}`;
        }
        return category; // Return as is for other cases
    }

    // Apply the formatting function to the categories
    let formattedCategories = categories.map(formatDate);

    // Create an array to hold the colored data points
    let coloredData = data.map(function(value) {
        let color;

        // Check the value against the threshold values and assign a color
        if (value > maxThreshold || value < minThreshold) {
            color = 'red'; // If value is out of the threshold range, make it red
        } else {
            color = 'green'; // Otherwise, make it green
        }

        // Return the value along with its associated color
        return {
            y: value,
            color: color
        };
    });

    // Create the Highcharts chart
    Highcharts.chart('containerchlrn', {
        chart: {
            type: 'column'
        },
        title: {
            text: 'Average Chlorine Levels'
        },
        credits: {
            enabled: false
        },
        xAxis: {
            categories: formattedCategories, // Period labels for X-axis
            title: {
                text: 'Period'
            }
        },
        yAxis: {
            title: {
                text: 'Average Chlorine Level'
            },
            plotLines: [{ // High alert threshold
                    value: maxThreshold,
                    color: 'blue',
                    dashStyle: 'shortdash',
                    width: 2,
                    label: {
                        text: `High Threshold (${maxThreshold})`
                    },
                    zIndex: 5 // Make sure the line appears in front of the bars
                },
                { // Low alert threshold
                    value: minThreshold,
                    color: 'orange',
                    dashStyle: 'shortdash',
                    width: 2,
                    label: {
                        text: `Low Threshold (${minThreshold})`
                    },
                    zIndex: 5 // Make sure the line appears in front of the bars
                }
            ]
        },
        series: [{
            name: 'Average Chlorine',
            data: coloredData, // Y-axis data points with dynamic colors
            showInLegend: false
        }]
    });
});
//-----------------------tds--------------------------------
document.addEventListener('DOMContentLoaded', function() {
			// Set locale options
		Highcharts.setOptions({
			lang: {
				decimalPoint: '.',
				thousandsSep: ','
			}
		});
    // Use the PHP variables passed from the controller
    let categories = @json($tdscategories);
    let data = @json($tdsdata);

    // Threshold values from PHP
    const maxThreshold = <?php echo $measures['TDS']->param_max_value; ?>;
    const minThreshold = <?php echo $measures['TDS']->param_min_value; ?>;

    // Function to format the date for X-axis
    function formatDate(category) {
        let parts = category.split('-');
        if (parts.length === 3) {
            // Y-m-d format, convert to d-m-Y
            return `${parts[2]}-${parts[1]}-${parts[0]}`;
        } else if (parts.length === 2) {
            // Y-m format, convert to Y-M (month name)
            const date = new Date(category + '-01');
            const monthName = date.toLocaleString('default', {
                month: 'short'
            });
            return `${parts[0]}-${monthName}`;
        }
        return category; // Return as is for other cases
    }

    // Apply the formatting function to the categories
    let formattedCategories = categories.map(formatDate);

    // Create an array to hold the colored data points
    let coloredData = data.map(function(value) {
        let color;

        // Check the value against the threshold values and assign a color
        if (value > maxThreshold || value < minThreshold) {
            color = 'red'; // If value is out of the threshold range, make it red
        } else {
            color = 'green'; // Otherwise, make it green
        }

        // Return the value along with its associated color
        return {
            y: value,
            color: color
        };
    });

    // Create the Highcharts chart
    Highcharts.chart('containertds', {
        chart: {
            type: 'column'
        },
        title: {
            text: 'Average TDS Levels'
        },
        credits: {
            enabled: false
        },
        xAxis: {
            categories: formattedCategories, // Period labels for X-axis
            title: {
                text: 'Period'
            }
        },
        yAxis: {
            title: {
                text: 'Average TDS Level'
            },
            plotLines: [{ // High alert threshold
                    value: maxThreshold,
                    color: 'blue',
                    dashStyle: 'shortdash',
                    width: 2,
                    label: {
                        text: `High Threshold (${maxThreshold})`
                    },
                    zIndex: 5 // Make sure the line appears in front of the bars
                },
                { // Low alert threshold
                    value: minThreshold,
                    color: 'orange',
                    dashStyle: 'shortdash',
                    width: 2,
                    label: {
                        text: `Low Threshold (${minThreshold})`
                    },
                    zIndex: 5 // Make sure the line appears in front of the bars
                }
            ]
        },
        series: [{
            name: 'Average TDS',
            data: coloredData, // Y-axis data points with dynamic colors
            showInLegend: false
        }]
    });
});
//-----------------------tur--------------------------------
document.addEventListener('DOMContentLoaded', function() {
			// Set locale options
		Highcharts.setOptions({
			lang: {
				decimalPoint: '.',
				thousandsSep: ','
			}
		});
    // Use the PHP variables passed from the controller
    let categories = @json($turcategories);
    let data = @json($turdata);

    // Threshold values from PHP
    const maxThreshold = <?php echo $measures['TUR']->param_max_value; ?>;
    const minThreshold = <?php echo $measures['TUR']->param_min_value; ?>;

    // Function to format the date for X-axis
    function formatDate(category) {
        let parts = category.split('-');
        if (parts.length === 3) {
            // Y-m-d format, convert to d-m-Y
            return `${parts[2]}-${parts[1]}-${parts[0]}`;
        } else if (parts.length === 2) {
            // Y-m format, convert to Y-M (month name)
            const date = new Date(category + '-01');
            const monthName = date.toLocaleString('default', {
                month: 'short'
            });
            return `${parts[0]}-${monthName}`;
        }
        return category; // Return as is for other cases
    }

    // Apply the formatting function to the categories
    let formattedCategories = categories.map(formatDate);

    // Create an array to hold the colored data points
    let coloredData = data.map(function(value) {
        let color;

        // Check the value against the threshold values and assign a color
        if (value > maxThreshold || value < minThreshold) {
            color = 'red'; // If value is out of the threshold range, make it red
        } else {
            color = 'green'; // Otherwise, make it green
        }

        // Return the value along with its associated color
        return {
            y: value,
            color: color
        };
    });

    // Create the Highcharts chart
    Highcharts.chart('containertur', {
        chart: {
            type: 'column'
        },
        title: {
            text: 'Average Tur Levels'
        },
        credits: {
            enabled: false
        },
        xAxis: {
            categories: formattedCategories, // Period labels for X-axis
            title: {
                text: 'Period'
            }
        },
        yAxis: {
            title: {
                text: 'Average Tur Level'
            },
            plotLines: [{ // High alert threshold
                    value: maxThreshold,
                    color: 'blue',
                    dashStyle: 'shortdash',
                    width: 2,
                    label: {
                        text: `High Threshold (${maxThreshold})`
                    },
                    zIndex: 5 // Make sure the line appears in front of the bars
                },
                { // Low alert threshold
                    value: minThreshold,
                    color: 'orange',
                    dashStyle: 'shortdash',
                    width: 2,
                    label: {
                        text: `Low Threshold (${minThreshold})`
                    },
                    zIndex: 5 // Make sure the line appears in front of the bars
                }
            ]
        },
        series: [{
            name: 'Average Tur',
            data: coloredData, // Y-axis data points with dynamic colors
            showInLegend: false
        }]
    });
});
//-----------------------Water level--------------------------------
document.addEventListener('DOMContentLoaded', function() {
			// Set locale options
		Highcharts.setOptions({
			lang: {
				decimalPoint: '.',
				thousandsSep: ','
			}
		});
    // Use the PHP variables passed from the controller
    let categories = @json($water_lvlcategories);
    let data = @json($water_lvldata);

    // Function to format the date for X-axis
    function formatDate(category) {
        let parts = category.split('-');
        if (parts.length === 3) {
            // Y-m-d format, convert to d-m-Y
            return `${parts[2]}-${parts[1]}-${parts[0]}`;
        } else if (parts.length === 2) {
            // Y-m format, convert to Y-M (month name)
            const date = new Date(category + '-01');
            const monthName = date.toLocaleString('default', {
                month: 'short'
            });
            return `${parts[0]}-${monthName}`;
        }
        return category; // Return as is for other cases
    }

    // Apply the formatting function to the categories
    let formattedCategories = categories.map(formatDate);

    // Create the Highcharts chart
    Highcharts.chart('containerwater_lvl', {
        chart: {
            type: 'column'
        },
        title: {
            text: 'Average Water Levels'
        },
        credits: {
            enabled: false
        },
        xAxis: {
            categories: formattedCategories, // Period labels for X-axis
            title: {
                text: 'Period'
            }
        },
        yAxis: {
            title: {
                text: 'Average Water Level'
            }
        },
        series: [{
            name: 'Average Water',
            data: data, // Y-axis data points (average water levels)
            color: 'green', // Set all bars to green
            showInLegend: false
        }]
    });
});
</script>

@push('scripts')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
$(function() {
    // Initialize datepickers with format dd-mm-yy
    $('#device_purchased_on, #device_purchased_on1').datepicker({
        dateFormat: 'dd-mm-yy'
    });

    // Event handler for fromdate selection
    $('#device_purchased_on').on('change', function() {
        var fromDate = $(this).datepicker('getDate');

        // Set maxDate on todate (fromDate + 7 days)
        if (fromDate) {
            var maxDate = new Date(fromDate);
            maxDate.setDate(maxDate.getDate() + 14);

            $('#device_purchased_on').datepicker('option', 'minDate', fromDate);
            $('#device_purchased_on1').datepicker('option', 'maxDate', maxDate);
        }
    });

    // Event handler for todate selection
    $('#device_purchased_on1').on('change', function() {
        var fromDate = $('#fromdate').datepicker('getDate');
        var toDate = $(this).datepicker('getDate');

        if (fromDate && toDate) {
            var diffDays = (toDate - fromDate) / (1000 * 60 * 60 * 24); // Difference in days

            if (diffDays > 14) {
                alert('The date range cannot exceed 15 days.');
                $(this).val(''); // Reset todate value
            }
        }
    });
});
</script>
@endpush

<script>
function validation() {
    if (document.getElementById('device_purchased_on').value == "") {
        $('#error-fdt').html('* From Date Is Required');
        $('#error-fdt').css('color', 'red');
        $('#device_purchased_on').focus();
        return false;
    }
    if (document.getElementById('device_purchased_on1').value == "") {
        $('#error-tdt').html('* To Date Is Required');
        $('#error-tdt').css('color', 'red');
        $('#device_purchased_on1').focus();
        return false;
    }

    if (document.getElementById('tank_list').value == "") {
        $('#error-tl').html('* Select A Tank');
        $('#error-tl').css('color', 'red');
        $('#tank_list').focus();
        return false;
    }

    return true;
}
</script>