@extends('layouts.main')

@section('content')
<main class="content">
        <div class="g-color"></div>
		<div class="table-header position-relative">
        <div class="row justify-content-between ">
		</div>
        <div class="row justify-content-between">
						<form class="mt-5" action="{{ route('outlierchart') }}" method="post">
						@csrf
							<div class="col-md-12">
							  <ul class="d-flex align-items-center p-0">
								<!--<li class="">
									<div class="date-input d-flex align-items-center position-relative"><b class="me-3">Date From:</b>
										<input class="form-control w-50" type="text" name="fromdate" value="<?php if($fdate == ""){ echo ""; }else{ echo date('d-m-Y',strtotime($fdate)); } ?>" id="device_purchased_on" autocomplete="off">
										<i class="ri-calendar-2-line"></i>
									</div>
								</li>-->
								<li class="">
									<div class="date-input d-flex align-items-center position-relative"><b class="me-3">Date
											From:</b>
										<span class="date-inputbox position-relative w-50">
											<input class="form-control" type="text" name="fromdate"
												value="<?php echo date('d-m-Y', strtotime($fdate)); ?>" id="device_purchased_on"
												autocomplete="off">
											<i class="ri-calendar-2-line"></i>
										</span>
									</div>
								</li>
								<!--<li class="">
									<div class=" date-input d-flex align-items-center position-relative"><b class="me-2">To :</b>
										<input class="form-control w-75" type="text" name="todate" value="<?php if($fdate == ""){ echo ""; }else{ echo date('d-m-Y',strtotime($tdate)); } ?>" id="device_purchased_on1" autocomplete="off">
										<i class="ri-calendar-2-line"></i>
									</div>
								</li>-->
								<li class="">
									<div class=" date-input d-flex align-items-center position-relative"><b class="me-2">To
											:</b>
										<span class="date-inputbox position-relative w-75">
											<input class="form-control" type="text" name="todate"
												value="<?php echo date('d-m-Y', strtotime($fdate)); ?>" id="device_purchased_on1"
												autocomplete="off">
											<i class="ri-calendar-2-line"></i>
										</span>
									</div>
								</li>
								<li class="">
								  <div class="d-flex align-items-center position-relative"><b class="me-3">Select Parameter:</b>
									<select class="form-select" name="device_type_id" id="device_type_id"
                                        aria-label="Default select example">
                                        <option value="">Select Parameter Type</option>
                                        <option value="chlrn" <?php if($phColumn == 'chlrn'){ ?> selected="selected" <?php } ?>>CL</option>
                                        <option value="ph" <?php if($phColumn == 'ph'){ ?> selected="selected" <?php } ?>>PH</option>
                                        <option value="iron_lvl" <?php if($phColumn == 'iron_lvl'){ ?> selected="selected" <?php } ?>>IRON</option>
                                        <option value="tds" <?php if($phColumn == 'tds'){ ?> selected="selected" <?php } ?>>TDS</option>
                                        <option value="tur" <?php if($phColumn == 'tur'){ ?> selected="selected" <?php } ?>>Turbidity</option>
                                        <!-- <option value="6">Temperature Sensor</option>-->
                                        <option value="water_lvl" <?php if($phColumn == 'water_lvl'){ ?> selected="selected" <?php } ?>>Water</option>
                                    </select>
								<input type="hidden" name="sval" value="1" />
								  </div>
								</li>
								<li class="">
								  <div class="btn-sec m-2">
									<button type="submit" class="btn btn-primary" onClick="return validation();">Submit</button>
								  </div>
								</li>
							  </ul>
							</div>
						</form>								
						</div>
    </div>
        <div class="position-relative">
          <div class="container-sec">
            <div class="cotainer-body p-4">
              <div class="page-hading">
                    <div class="d-flex align-items-center position-relative">
						<h2 class="d-flex align-items-center me-4 mb-0">Outlier Report</h2>
						<form method="get" class="text-right" action="{{route('outlierexcel',$enc_data)}}">
                            <button class="btn download-btn ms-2"><i class="ri-folder-download-fill"></i> Download
                            </button>
                        </form>
                    </div>
                </div>
				<div class="row row-spacing">
				  <div class="col-md-12">&nbsp;</div>	
				</div>
<?php // echo "<pre>"; print_r($measures);  die; ?>
			  					  
              <div class="add-tank">
			  @foreach($data as $tank_id => $tank_data)
					<div class="row">					
						@php
							$tankName = $tank_data['tank_name']; 
							$tankResults = $tank_data['result'];
							// Prepare data for Highcharts
							$times = [];
							$phValues = [];					
						
							foreach ($tankResults as $result) {
								$times[] = $result->created_at;  // x-axis (time)
								$phValues[] = (float) $result->paramval;  // y-axis (ph value)
							}
						@endphp
						
						<div class="col-md-12">
							<div id="container-{{ $tank_id }}" style="width: 100%; height: 500px;">
								@if(empty($tankResults))
									<p>There is no record available</p>
								@else
									<script>
													// Set locale options
													Highcharts.setOptions({
														lang: {
															decimalPoint: '.',
															thousandsSep: ','
														}
													});
										Highcharts.chart('container-{{ $tank_id }}', {
											chart: {
												type: 'column'  // Bar chart (vertical columns)
											},
											title: {
												text: '{{ $tankName }} {{ $paramName }} Values Over Time'
											},
											xAxis: {
												categories: {!! json_encode($times) !!},  // Time data for x-axis
												title: {
													text: 'Time'
												}
											},
											yAxis: {
												title: {
													text: '{{ $paramName }} Value'
												},
												plotLines: [{
													value: {{ $measures->param_min_value }},
													color: 'red',
													width: 2,
													dashStyle: 'Dash',
													zIndex: 5,  // Ensures the line is drawn on top of bars
													label: {
														text: 'Min Threshold ({{ $measures->param_min_value }})',
														align: 'left',
														style: {
															color: 'orange'
														}
													}
												}, {
													value: {{ $measures->param_max_value }},
													color: 'green',
													width: 2,
													dashStyle: 'Dash',
													zIndex: 5,  // Ensures the line is drawn on top of bars
													label: {
														text: 'Max Threshold ({{ $measures->param_max_value }})',
														align: 'left',
														style: {
															color: 'red'
														}
													}
												}]
											},
											series: [{
												name: '{{ $paramName }}',
												data: {!! json_encode($phValues) !!},  // PH data for y-axis
												color: '#7cb5ec'  // Optional: Set a custom color for the bars
											}],
											tooltip: {
												valueSuffix: ' {{ $paramName }}'
											}
										});
									</script>
								@endif
							</div>
						</div>
						
						<div class="row row-spacing">
							<div class="col-md-12">&nbsp;</div>	
						</div>
					</div>
				@endforeach          

              </div>			  
            </div>
          </div>
        </div>

        
      </main>

@endsection	 

<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/accessibility.js"></script>



@push('scripts')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
        $(function() {
            // Initialize datepickers with format dd-mm-yy
            $('#device_purchased_on, #device_purchased_on1').datepicker({
                dateFormat: 'dd-mm-yy'
            });

            // Event handler for fromdate selection
            $('#device_purchased_on').on('change', function() {
                var fromDate = $(this).datepicker('getDate');

                // Set maxDate on todate (fromDate + 7 days)
                if (fromDate) {
                    var maxDate = new Date(fromDate);
                    maxDate.setDate(maxDate.getDate() + 29);

                    $('#device_purchased_on').datepicker('option', 'minDate', fromDate);
                    $('#device_purchased_on1').datepicker('option', 'maxDate', maxDate);
                }
            });

            // Event handler for todate selection
            $('#device_purchased_on1').on('change', function() {
                var fromDate = $('#fromdate').datepicker('getDate');
                var toDate = $(this).datepicker('getDate');

                if (fromDate && toDate) {
                    var diffDays = (toDate - fromDate) / (1000 * 60 * 60 * 24); // Difference in days

                    if (diffDays > 29) {
                        alert('The date range cannot exceed 15 days.');
                        $(this).val(''); // Reset todate value
                    }
                }
            });
        });
    </script>
@endpush

<script>
  function validation() {
    if (document.getElementById('device_purchased_on').value == "") {
      $('#error-fdt').html('* From Date Is Required');
      $('#error-fdt').css('color', 'red');
      $('#device_purchased_on').focus();
      return false;
    }
    if (document.getElementById('device_purchased_on1').value == "") {
      $('#error-tdt').html('* To Date Is Required');
      $('#error-tdt').css('color', 'red');
      $('#device_purchased_on1').focus();
      return false;
    }
    
    if (document.getElementById('tank_list').value == "") {
      $('#error-tl').html('* Select A Tank');
      $('#error-tl').css('color', 'red');
      $('#tank_list').focus();
        return false;
    }
    
    return true;
  }
</script>
