@extends('layouts.main')

@section('content')
<main class="content">
        <div class="g-color"></div>
		<div class="table-header position-relative">
        <div class="row justify-content-between">
			<form class="mt-5" action="{{ route('tanksummary') }}" method="post">
			@csrf
				<div class="col-md-12">
				  <ul class="d-flex align-items-center p-0">
					<li class="">
					  <div class="d-flex align-items-center position-relative"><b class="me-3">Date Range:</b>
						<input class="form-control w-50" value="<?php if($fdate == ""){ echo ""; }else{ echo date('d-m-Y',strtotime($fdate)); } ?>" name="fromdate" id="device_purchased_on" type="text" autocomplete="off">
					  </div>
					</li>
					<li class="">
					  <div class="d-flex align-items-center position-relative"><b class="me-2">To :</b>
						<input class="form-control w-75" type="text" value="<?php if($fdate == ""){ echo ""; }else{ echo date('d-m-Y',strtotime($tdate)); } ?>" id="device_purchased_on1" name="todate" autocomplete="off">
					  </div>
					</li>
					<li class="">
					  <div class="d-flex align-items-center position-relative"><b class="me-3">Select Tank:</b>
						<select class="form-select w-75" name="tank_list" id="tank_list" aria-label="Default select example">
					  <option  value="">Select Tank</option>
					   @foreach ($tanks as $tank)
					  <option value="{{ $tank->tank_uid }}" @if ($tank_uid == $tank->tank_uid){{ 'selected' }} @endif >{{ $tank->tank_name.'('.$tank->tank_uid.')' }}</option>
					  @endforeach
					</select>
					<input type="hidden" name="sval" value="1" />
					  </div>
					</li>
					<li class="">
					  <div class="btn-sec m-2">
						<button type="submit" class="btn btn-primary" onClick="return validation();">Submit</button>
					  </div>
					</li>
				  </ul>
				</div>
			</form>								
		</div>
    </div>
        <div class="position-relative">
          <div class="container-sec">
            <div class="cotainer-body p-4">
              <div class="page-hading">
                    <div class="d-flex align-items-center position-relative">                        
						<a href="{{ route('tankdetails') }}" class="d-flex align-items-center me-4 mb-0">
							Daily Summary Of Tank Data
						</a>
						<div class="detasheet-graph-icon ms-auto">
							<a href="javascript:history.back()">Datasheet</a>
							<a href="#" class="active">Graph</a>
						</div>
						                        
                    </div>
                </div>
              <div class="add-tank">
			  	<div class="row row-spacing">
				  <div class="col-md-12">&nbsp;</div>	
				 </div>
                <div class="row">
                    <div class="col-md-6">
                      <div id="container"></div>
                    </div>
					
                    <div class="col-md-6">
                      <div id="container1"></div>
                    </div>
                    
                  </div>
				  
				<div class="row">
                    <div class="col-md-6">
                      <div id="container2"></div>
                    </div>
					
                    <div class="col-md-6">
                      <div id="container3"></div>
                    </div>
                    
                  </div>
				  
				<div class="row">
                    <div class="col-md-6">
                      <div id="container4"></div>
                    </div>
					
                    <div class="col-md-6">
                      <div id="container5"></div>
                    </div>
                    
                  </div>                

              </div>
            </div>
          </div>
        </div>

        
      </main>

@endsection	 

<script src="https://code.highcharts.com/highcharts.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    var chart = Highcharts.chart('container', {
        chart: {
            type: 'column'  // Use 'column' for vertical bars
        },
        title: {
            text: 'pH Levels'
        },
        xAxis: {
            type: 'datetime',  // X-axis is time-based
            title: {
                text: 'Time'
            }
        },
        yAxis: {
            title: {
                text: 'pH Value'
            }
        },
        series: [{
            name: 'pH',
            data: [
                @foreach($phdata as $point)
                    [{{ strtotime($point->time_column) * 1000 }}, {{ $point->ph_value_column }}],
                @endforeach
            ],
			color: '#71f093'
        }]
    });
});

document.addEventListener('DOMContentLoaded', function () {
    var chart = Highcharts.chart('container1', {
        chart: {
            type: 'column'  // Use 'column' for vertical bars
        },
        title: {
            text: 'OPR Levels'
        },
        xAxis: {
            type: 'datetime',  // X-axis is time-based
            title: {
                text: 'Time'
            }
        },
        yAxis: {
            title: {
                text: 'OPR Value'
            }
        },
        series: [{
            name: 'OPR',
            data: [
                @foreach($oprdata as $point)
                    [{{ strtotime($point->time_column) * 1000 }}, {{ $point->opr_value_column }}],
                @endforeach
            ],
			color: '#71a880'
        }]
    });
});

document.addEventListener('DOMContentLoaded', function () {
    var chart = Highcharts.chart('container2', {
        chart: {
            type: 'column'  // Use 'column' for vertical bars
        },
        title: {
            text: 'Chlorine Levels'
        },
        xAxis: {
            type: 'datetime',  // X-axis is time-based
            title: {
                text: 'Time'
            }
        },
        yAxis: {
            title: {
                text: 'Chlorine Value'
            }
        },
        series: [{
            name: 'Chlorine',
            data: [
                @foreach($chlrndata as $point)
                    [{{ strtotime($point->time_column) * 1000 }}, {{ $point->chlrn_value_column }}],
                @endforeach
            ],
			color: '#b8dbc2'
        }]
    });
});

document.addEventListener('DOMContentLoaded', function () {
    var chart = Highcharts.chart('container3', {
        chart: {
            type: 'column'  // Use 'column' for vertical bars
        },
        title: {
            text: 'TDS Levels'
        },
        xAxis: {
            type: 'datetime',  // X-axis is time-based
            title: {
                text: 'Time'
            }
        },
        yAxis: {
            title: {
                text: 'TDS Value'
            }
        },
        series: [{
            name: 'TDS',
            data: [
                @foreach($tdsdata as $point)
                    [{{ strtotime($point->time_column) * 1000 }}, {{ $point->tds_value_column }}],
                @endforeach
            ],
			color: '#706e10'
        }]
    });
});

document.addEventListener('DOMContentLoaded', function () {
    var chart = Highcharts.chart('container4', {
        chart: {
            type: 'column'  // Use 'column' for vertical bars
        },
        title: {
            text: 'Turbudity Levels'
        },
        xAxis: {
            type: 'datetime',  // X-axis is time-based
            title: {
                text: 'Time'
            }
        },
        yAxis: {
            title: {
                text: 'Turbudity Value'
            }
        },
        series: [{
            name: 'Turbudity',
            data: [
                @foreach($turdata as $point)
                    [{{ strtotime($point->time_column) * 1000 }}, {{ $point->tur_value_column }}],
                @endforeach
            ],
			color: '#1e118f'
        }]
    });
});

document.addEventListener('DOMContentLoaded', function () {
    var chart = Highcharts.chart('container5', {
        chart: {
            type: 'column'  // Use 'column' for vertical bars
        },
        title: {
            text: 'Water Levels'
        },
        xAxis: {
            type: 'datetime',  // X-axis is time-based
            title: {
                text: 'Time'
            }
        },
        yAxis: {
            title: {
                text: 'Water Value'
            }
        },
        series: [{
            name: 'Water Levels',
            data: [
                @foreach($water_lvldata as $point)
                    [{{ strtotime($point->time_column) * 1000 }}, {{ $point->water_lvl_value_column }}],
                @endforeach
            ]
        }]
    });
});
</script>
@push('scripts')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
  $(function() {
    $("#device_purchased_on").datepicker({
      dateFormat: 'dd-mm-yy' // Example format
    });
  });

  $(function() {
    $("#device_purchased_on1").datepicker({
      dateFormat: 'dd-mm-yy' // Example format
    });
  });
</script>
@endpush