@extends('layouts.main')

@section('content')
<main class="content">
    <div class="g-color"></div>
    <div class="table-header position-relative">
        <div class="row justify-content-between ">
        </div>
        <div class="row justify-content-between">
            <form class="hd-date-input mt-5" action="{{ route('comparativechart') }}" method="post">
                @csrf
                <div class="col-md-12">
                    <ul class="d-flex align-items-center p-0">
                        <!--<li class="">
                            <div class="d-flex align-items-center position-relative"><b class="me-3">Date Range:</b>
                                 <span class="date-inputbox position-relative w-50">
                                <input class="form-control" value="<?php if ($fdate == "") {
                                                                            echo "";
                                                                        } else {
                                                                            echo date('d-m-Y', strtotime($fdate));
                                                                        } ?>" name="fromdate" id="device_purchased_on" type="text" autocomplete="off">
                                                                    </span>
                            </div>
                        </li>-->
						<li class="">
									<div class="date-input d-flex align-items-center position-relative"><b class="me-3">Date
											From:</b>
										<span class="date-inputbox position-relative w-50">
											<input class="form-control" type="text" name="fromdate"
												value="<?php echo date('d-m-Y', strtotime($fdate)); ?>" id="device_purchased_on"
												autocomplete="off">
											<i class="ri-calendar-2-line"></i>
										</span>
									</div>
								</li>
                        <!--<li class="">
                            <div class="d-flex align-items-center position-relative"><b class="me-2">To :</b>
                                 <span class="date-inputbox position-relative  w-75">
                                <input class="form-control" type="text" value="<?php if ($fdate == "") {
                                                                                        echo "";
                                                                                    } else {
                                                                                        echo date('d-m-Y', strtotime($tdate));
                                                                                    } ?>" id="device_purchased_on1" name="todate" autocomplete="off">
                                                                                </span>
                            </div>
                        </li>-->
						<li class="">
									<div class=" date-input d-flex align-items-center position-relative"><b class="me-2">To
											:</b>
										<span class="date-inputbox position-relative w-75">
											<input class="form-control" type="text" name="todate"
												value="<?php echo date('d-m-Y', strtotime($tdate)); ?>" id="device_purchased_on1"
												autocomplete="off">
											<i class="ri-calendar-2-line"></i>
										</span>
									</div>
								</li>
                        <li class="">
                            <div class="d-flex align-items-center position-relative"><b class="me-3">Select KPI:</b>
                                <select class="form-select" name="device_type_id" id="device_type_id" aria-label="Default select example">
                                    <option value="">Select Parameter Type</option>
                                    <option <?php if ($param == 'chlrn') { ?> selected="selected" <?php } ?> value="chlrn">CL </option>
                                    <option <?php if ($param == 'ph') { ?> selected="selected" <?php } ?> value="ph">PH </option>
                                    <option <?php if ($param == 'iron_lvl') { ?> selected="selected" <?php } ?> value="iron_lvl">IRON </option>
                                    <option <?php if ($param == 'tds') { ?> selected="selected" <?php } ?> value="tds">TDS </option>
                                    <option <?php if ($param == 'tur') { ?> selected="selected" <?php } ?> value="tur">Turbidity </option>
                                    <!-- <option value="6">Temperature Sensor</option>-->
                                    <option value="water_lvl">Water Level</option>
                                </select>
                                <input type="hidden" name="sval" value="1" />
                            </div>
                        </li>
                        <li class="">
                            <div class="btn-sec m-2">
                                <button type="submit" class="btn btn-primary" onClick="return validation();">Submit</button>
                            </div>
                        </li>
                    </ul>
                </div>
            </form>
        </div>
    </div>
    <div class="position-relative">
        <div class="container-sec">
            <div class="cotainer-body p-4">
                <div class="page-hading">
                    <div class="d-flex align-items-center position-relative d-sm-block d-md-flex">
                        <h2>Comparative Analysis Report</h2>
                    </div>
                </div>
                <div class="row row-spacing">
                    <div class="col-md-12">&nbsp;</div>
                </div>
                
                @if($sval == 1)
                
                <?php // echo "<pre>"; print_r($results);  die; 
                ?>
                <div class="add-tank">
                    <div class="row">
                        <div class="col-md-12">
                            <div id="container"></div>
                        </div>
                    </div>
                    <div class="row row-spacing">
                        <div class="col-md-12">&nbsp;</div>
                    </div>
                </div>
                @else
                <div class="add-tank">
                    <div class="row">
                        <div class="col-md-12">
                            <div id="container88">
                                <div align="center">
                                    <h2>Please Select Date and Tank To Generate Report</h2>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row row-spacing">
                        <div class="col-md-12">&nbsp;</div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>


</main>

@endsection

<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/accessibility.js"></script>



@push('scripts')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
    $(function() {
        $("#device_purchased_on").datepicker({
            dateFormat: 'dd-mm-yy' // Example format
        });
    });

    $(function() {
        $("#device_purchased_on1").datepicker({
            dateFormat: 'dd-mm-yy' // Example format
        });
    });
</script>
@endpush

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Data passed from the backend (your PHP array)
        let data = {!! json_encode($results) !!};
		console.log(data);
        // Extract categories (dates) for the X-axis and sort them
        let categories = Object.keys(data).sort((a, b) => new Date(a) - new Date(b));

        // Get all unique tank IDs (sensor IDs)
        let tankIds = [...new Set(Object.values(data).flatMap(obj => Object.keys(obj)))];

        // Prepare series data for each tank (sensor ID)
        let series = tankIds.map(tankId => {
            return {
                name: tankId, // Tank ID (or name if available)
                data: categories.map(date => {
                    // Fetch and format the data to two decimal places, or use null for missing values
                    return data[date][tankId] !== undefined ? parseFloat(data[date][tankId].toFixed(2)) : null;
                })
            };
        });

        // Create the Highcharts bar chart
        Highcharts.chart('container', {
            chart: {
                type: 'column' // Bar chart type
            },
            title: {
                text: 'Sensor Readings Over Time'
            },
            xAxis: {
                categories: categories, // Dates on the X-axis (sorted)
				type: 'datetime',
                title: {
                    text: 'Date'
                },
                labels: {
                    rotation: -45, // Rotate labels for better readability
                }
            },
            yAxis: {
                title: {
                    text: 'Parameter Values'
                }
            },
            tooltip: {
                shared: true, // Show all values in the tooltip when hovering
                valueDecimals: 2 // Format values in tooltip to two decimal places
            },
            series: series, // Series data (one series per tank)
			credits: false
        });
    });
</script>

<script>
    function validation() {
        if (document.getElementById('device_purchased_on').value == "") {
            $('#error-fdt').html('* From Date Is Required');
            $('#error-fdt').css('color', 'red');
            $('#device_purchased_on').focus();
            return false;
        }
        if (document.getElementById('device_purchased_on1').value == "") {
            $('#error-tdt').html('* To Date Is Required');
            $('#error-tdt').css('color', 'red');
            $('#device_purchased_on1').focus();
            return false;
        }

        if (document.getElementById('tank_list').value == "") {
            $('#error-tl').html('* Select A Tank');
            $('#error-tl').css('color', 'red');
            $('#tank_list').focus();
            return false;
        }

        return true;
    }
</script>