@extends('layouts.main')

@section('content')
<main class="content">
    <div class="g-color"></div>
    <div class="position-relative">
        <div class="container-sec">
            <div class="cotainer-body p-4">
                <div class="page-hading">
                    <a href="#" class="d-flex align-items-center">
                        <i class="ri-arrow-left-line"></i> Edit Water Health Param Measure
                    </a>
                </div>
                <div class="add-tank">
                    <form class="mt-5" action="{{ route('update_measaure') }}" method="post">
                        @csrf
                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>Parameter Name</b></label>
                                    <input type="text" class="form-control" name="param_name" id="param_name" aria-describedby="" value="{{ $measure->param_name }}" readonly>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>Parameter Maximum Value</b></label>
                                    <input type="text" class="form-control" name="param_max_value" id="param_max_value" value="{{ $measure->param_max_value }}" onkeypress="return isNumberKey(this, event)" required>
                                    @error('param_max_value')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label"><b>Parameter Minimum Value</b></label>
                                    <input type="text" class="form-control" name="param_min_value" id="param_min_value" value="{{ $measure->param_min_value }}" onkeypress="return isNumberKey(this, event)" required>
                                    @error('param_min_value')
                                    <div class="error">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <input type="hidden" name="measure_id" value="{{ $measure->id }}" />
                        <div class="btn-footer">
                            <div class="btn-sec m-2">
                                <button type="submit" class="btn btn-brder">Cancel</button>
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>

                    </form>



                </div>
            </div>
        </div>
    </div>


</main>

@endsection
<script>
    function isNumberKey(txt, evt) {
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode == 46) {
            //Check if the text already contains the . character
            if (txt.value.indexOf('.') === -1) {
                return true;
            } else {
                return false;
            }
        } else {
            if (charCode > 31 &&
                (charCode < 48 || charCode > 57))
                return false;
        }
        return true;
    }
</script>