<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTankMasterTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tank_masters', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('tank_uid')->unique();
            $table->string('tank_name');
            $table->text('tank_loc')->nullable();;
            $table->double('tank_lat_loc')->nullable();;
            $table->double('tank_long_loc')->nullable();;
            $table->string('address1')->nullable();;
            $table->string('address2')->nullable();;
            $table->string('city')->nullable();;
            $table->string('state')->nullable();;
            $table->string('zip')->nullable();;
            $table->longText('description')->nullable();;
            $table->string('contact_person_name')->nullable();;
            $table->string('contact_person_contact_no')->nullable();;
            $table->string('contact_person_email')->nullable();;
            $table->unsignedBigInteger('tank_status_id')->nullable();;
            $table->dateTime('created_at');
            $table->unsignedBigInteger('created_by')->nullable();;
            $table->dateTime('updated_at')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tank_masters');
    }
}
