<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Mail;
use Illuminate\Http\Request;

class CronController extends Controller
{
    //Check Webhook
	public function fetchWaterData() 
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'http://dev-phe.maxbridgesolution.in/webhook/get_water_data.php',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'working_alive',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));
        // Execute the cURL request
        $response = curl_exec($curl);
        // Get the HTTP status code
        $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        // Close the cURL session
        curl_close($curl);
		
		echo 'Status: '.$http_status;
		// Check if the status code is not 200
        if ($http_status != 200) {
            // Send a warning email
            $this->sendWarningMail($http_status);
        }
        
        exit();
    }
	
	// Function to send warning email
    protected function sendWarningMail($http_status)
    {
        $to_email = 'u.nandy1992@gmail.com';
        $subject = 'WebHook API Response';
        $message = "The WebHook API returned a status code of: " . $http_status;

        // Using Laravel's mail functionality to send email
        Mail::raw($message, function ($mail) use ($to_email, $subject) {
            $mail->to($to_email)
                ->subject($subject);
        });

        echo "Warning mail sent to " . $to_email . "\n";
    }
	
	public function webhookpayload() 
    {
       
	   $curl = curl_init();

		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'http://dev-phe.maxbridgesolution.in/webhook/get_water_data.php?val=%24WAT%7C861100061000774%7CCL%7C0%7CTDS%7C86%7CPH%7C6.20%7CTUR%7C0.00%7COPR%7C000.00%7C1726583612%24',
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'POST',
		));
		
		$response = curl_exec($curl);
		
		curl_close($curl);
		echo $response;
	   
	   
        // Get the HTTP status code
        $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        // Close the cURL session
        //curl_close($curl);
		
		echo 'Status: '.$http_status;
		// Check if the status code is not 200
        if ($http_status != 200) {
            // Send a warning email
            $this->sendWarningMail($http_status);
        }
        
        exit();
    }
}
