<?php include 'include/header.php'; ?>
<?php
session_start();
$_SESSION['captcha_id'] = round(rand(100000, 999999));
?>
<!-- <link rel="stylesheet" href="css/try.css" defer> -->
<div id="content" class="site-content pt-66">
    <main class="homepage homepage_new" id="homepage-content">

        <section class="banner-section mt-66">
            <div class="banner-txt">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12">
                            <h1 class="fw-semibold">Indoor asset tracking with Maps</h1>
                            <div class="default-breadcrumb">
                                <nav aria-label="breadcrumb">
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="index.php" class="fw-medium ">Home</a></li>
                                        <li class="breadcrumb-item"><span class="fw-medium">What We Do</span></li>
                                        <li class="breadcrumb-item fw-medium" aria-current="page">Indoor asset tracking
                                        </li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <img src="images/indoor-asset-banner.jpg" style="" class="buisness-inteligence-banner-img">
        </section>

        <section class="indoor-asset-traking-midSection">
            <div class="container">
                <p class="top-para">
                    In the complex and dynamic environments of warehouses and manufacturing industries, managing assets
                    and inventory efficiently is crucial for maintaining operational continuity and
                    competitiveness.Traditional methods of tracking equipment, tools, and raw materials can be
                    time-consuming, error-prone, and costly. Enter the IoT/RFID/GPS Indoor Asset Tracking and Inventory
                    Management Solution – a cutting-edge system that revolutionizes asset visibility and inventory
                    control within warehouse and manufacturing facilities.
                </p>
            </div>

            <div class="container">

                <div class="cards-section">


                    <div class="highlight-Data-card">
                        <div class="left">
                            <img src="images/warehouse-manufacturing.jpg" alt="">
                        </div>
                        <div class="right">
                            <p class="title">
                                Enhancing Warehouse and Manufacturing Efficiency with IoT/
                                RFID/GPS Indoor Asset Tracking
                            </p>
                            <p class="para">
                                In the interconnected world of warehousing and manufacturing, the ability to track and
                                manage assets efficiently is crucial. The integration of IoT/RFID/GPS indoor asset
                                tracking
                                systems with interactive maps and comprehensive inventory management is transforming the
                                industry.
                            </p>
                        </div>

                    </div>
                    <div class="highlight-Data-card">
                        <div class="left">
                            <img src="images/indoor-asset-interactive-maps.jpg" alt="">
                        </div>
                        <div class="right">
                            <p class="title">
                                Interactive Maps for Real-Time Visibility
                            </p>
                            <p class="para">
                                Interactive maps powered by IoT technology provide a bird's-eye view of the entire
                                warehouse or manufacturing floor. These maps display the real-time location of assets,
                                allowing for quick navigation and streamlined operations.
                            </p>
                        </div>

                    </div>
                    <div class="highlight-Data-card">
                        <div class="left">
                            <img src="images/indoor-asset-precision-speed.jpg" alt="">
                        </div>
                        <div class="right">
                            <p class="title">
                                IoT/RFID/GPS for Precision and Speed
                            </p>
                            <p class="para">
                                IRFID technology offers precision in tracking, enabling instant identification and
                                location of assets within the facility. This speeds up the inventory process and reduces
                                the likelihood of human error, ensuring that every item is accounted for.
                            </p>
                        </div>

                    </div>
                    <div class="highlight-Data-card">
                        <div class="left">
                            <img src="images/indoor-asset-gps.jpg" alt="">
                        </div>
                        <div class="right">
                            <p class="title">
                                GPS for Indoor and Outdoor Tracking
                            </p>
                            <p class="para">
                                While GPS is traditionally used for outdoor tracking, advancements in technology have
                                made it possible to utilize GPS for indoor asset tracking as well. This ensures seamless
                                transition and tracking capabilities, whether the assets are within the warehouse or in
                                transit.
                            </p>
                        </div>

                    </div>
                    <div class="highlight-Data-card">
                        <div class="left">
                            <img src="images/indoor-asset-data-analytics.jpg" alt="">
                        </div>
                        <div class="right">
                            <p class="title">
                                Data Analytics for Continuous Improvement
                            </p>
                            <p class="para">
                                The data collected from these tracking solutions is a goldmine for analytics. It enables
                                businesses to identify patterns, predict trends, and make data-driven decisions to
                                enhance operational efficiency.
                            </p>
                        </div>

                    </div>



                </div>
            </div>

        </section>
        <section class=" bottom-section pt-5 pb-5">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <p class="para" style="color:black;">
                            These systems not only improve the efficiency and accuracy of asset tracking and inventory
                            management but also contribute to overall strategic planning and operational excellence. As
                            technology advances, these systems will continue to evolve, offering even greater
                            capabilities and integration possibilities.
                        </p>
                        <div class="gradient-box sm-box">For more information download the Brochure <button
                                class="btn btn-white" onclick="contactFormToggle(event)">Click
                                Here</button></div>
                    </div>
                </div>
            </div>
        </section>





    </main>


    <section class="contact-form-modal align-items-start d-none" id="contact-form-modal">
        <div class="contact-form-modal-body">
            <button class="close-btn" onclick="contactFormToggle(event)">
                <span>
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                        stroke="currentColor" class="w-6 h-6">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" />
                    </svg>

                </span>
            </button>

            <h2>
                Download Brochure Form
            </h2>
            <form action="" onsubmit="onContactFormSubmit(event)" id="contactForm" method="post">
                <div class="row">
                    <div class="col-md-12 col-lg-6">
                        <div class="form-group">
                            <label for="" class="form-label"><span style="color:red;">*</span>Name</label>
                            <input type="text" name="name" id="name" class="form-control" placeholder="Name">
                            <span class="help-block form-error" id="name_err" style="display:none;color: red;">Please
                                enter name</span>
                        </div>
                    </div>
                    <div class="col-md-12 col-lg-6">
                        <div class="form-group">
                            <label for="" class="form-label"><span style="color:red;">*</span>Email</label>
                            <input type="email" name="email" id="email" class="form-control" placeholder="Email">
                            <span class="help-block form-error" id="email_err" style="display:none;color: red;">Please
                                enter valid email</span>
                        </div>
                    </div>
                    <div class="col-md-12 col-lg-6">
                        <div class="form-group">
                            <label for="" class="form-label"><span style="color:red;">*</span>Phone No.</label>
                            <input type="text" name="phone" id="phone" class="form-control" placeholder="Phone">
                            <span class="help-block form-error" id="phone_err" style="display:none;color: red;">Please
                                enter valid Phone No.</span>
                        </div>
                    </div>
                    <div class="col-md-12 col-lg-6">
                        <div class="form-group">
                            <label for="" class="form-label"><span style="color:red;">*</span>Company</label>
                            <input type="text" name="company" id="company" class="form-control" placeholder="company">
                            <span class="help-block form-error" id="company_err" style="display:none;color: red;">Please
                                enter Company Name</span>
                        </div>
                    </div>
                    <div class="col-md-12 ">
                        <div class="form-group">
                            <label for="" class="form-label"><span style="color:red;">*</span>Message</label>
                            <textarea class="form-control" id="message" name="message" rows="7"
                                placeholder="Please enter your message*" spellcheck="false"></textarea>
                            <span class="help-block form-error" id="message_err" style="display:none;color: red;">Please
                                enter message</span>
                        </div>
                    </div>
                    <div class="col-md-4 form-group">
                        <button class="btn captcha-pagebtn"><?php echo $_SESSION['captcha_id'] ?></button>
                    </div>
                    <div class="col-md-8 form-group">
                        <input name="captcha" type="number" class="form-control" id="captcha"
                            placeholder="Enter Captcha Code*" pattern="/^-?\d+\.?\d*$/"
                            onKeyPress="if(this.value.length==6) return false;" />
                        <span class="help-block form-error" id="captcha_err" style="display:none;color: red;">Please
                            enter captcha code</span>
                        <span class="help-block form-error" id="valid_captcha_err"
                            style="display:none;color: red;">Captcha code doesn't match</span>
                    </div>
                    <div class="d-flex justify-content-end">
                        <button class="btn btn-blue mt-3" type="submit">
                            Submit
                        </button>
                    </div>
            </form>

        </div>

    </section>
</div>
<?php include 'include/footer.php'; ?>
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.css">
<link rel="stylesheet" type="text/css"
    href="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>


<script>
function contactFormToggle(event) {
    let modalForm = document.getElementById('contact-form-modal');

    if (modalForm.classList.contains('d-none')) {
        modalForm.classList.remove('d-none');
    } else {
        modalForm.classList.add('d-none');
    }
}
var cap = "<?php echo $_SESSION['captcha_id'] ?>";

function IsValidRegEmailId(email) {
    var filter =
        /^([a-zA-Z0-9_\-])+(\.([a-zA-Z0-9_\-])+)*@((\[(((([0-1])?([0-9])?[0-9])|(2[0-4][0-9])|(2[0-5][0-5])))\.(((([0-1])?([0-9])?[0-9])|(2[0-4][0-9])|(2[0-5][0-5])))\.(((([0-1])?([0-9])?[0-9])|(2[0-4][0-9])|(2[0-5][0-5])))\.(((([0-1])?([0-9])?[0-9])|(2[0-4][0-9])|(2[0-5][0-5]))\]))|((([a-zA-Z0-9])+(([\-])+([a-zA-Z0-9])+)*\.)+([a-zA-Z])+(([\-])+([a-zA-Z0-9])+)*))$/;
    return filter.test(email);
}


function onContactFormSubmit(event) {
    //alert("ok");
    event.preventDefault();

    $("#name_err").hide();
    $("#phone_err").hide();
    $("#email_err").hide();
    $("#company_err").hide();
    $("#message_err").hide();
    $("#captcha_err").hide();
    $("#valid_captcha_err").hide();

    if ($.trim($("#name").val()) == "") {
        $("#name_err").show();
        $("#name").focus();
    } else if ($.trim($("#phone").val()) == "") {
        $("#phone_err").show();
        $("#phone").focus();
    } else if ($.trim($("#email").val()) == "") {
        $("#email_err").show();
        $("#email").focus();
    } else if (!IsValidRegEmailId($.trim($("#email").val()))) {
        $("#email_err").show();
        $("#email").focus();
    } else if ($.trim($("#company").val()) == "") {
        $("#company_err").show();
        $("#company").focus();
    } else if ($.trim($("#message").val()) == "") {
        $("#message_err").show();
        $("#message").focus();
    } else if ($.trim($("#captcha").val()) == "") {
        $("#captcha_err").show();
        $("#captcha").focus();
    } else if ($.trim($("#captcha").val()) != cap) {
        $("#valid_captcha_err").show();
        $("#captcha").focus();
    } else {
        var form = $('#contactForm');

        //alert(form);
        $.ajax({
            url: "send_email_for_indoor_tracking.php",
            method: form.attr('method'),
            data: form.serialize(),
            success: function(result) {
                var resp = JSON.parse(result);
                //alert(resp.status);
                if (resp.status == "success") {
                    // alert(resp.msg);
                    swal("", resp.msg, "success");
                    setTimeout(function() { // wait for 5 secs(2)
                        location.reload();
                    }, 2000);
                    var link = document.createElement('a');
                    link.href = "./pdf/Indoor-Asset-Management-Brochure.pdf";
                    link.download = './pdf/Indoor-Asset-Management-Brochure.pdf';
                    link.dispatchEvent(new MouseEvent('click'));
                } else {
                    swal("", resp.msg, "error");
                    // alert(resp.msg);
                }
            }
        });
        return false;
    }
}
</script>