<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends VA_Controller {

    public function __construct()
    {
        parent::__construct();
		
		$models = array('login_model');
		$this->load->model($models);
    }

    public function index_post()
    {
        $username = $this->post('username');
        $password = $this->post('password');
		
		if (empty($username)) {
			$this->response([
                    'status' 	=> FALSE,
					'errors' 	=> 'request_parameter_missing2',
                    'message' 	=> 'No username were provided'
                ], VA_Controller::HTTP_BAD_REQUEST);
		}
        else
		if (empty($password)) {
			$this->response([
                    'status' 	=> FALSE,
					'errors' 	=> 'request_parameter_missing',
                    'message' 	=> 'No password were provided'
				], VA_Controller::HTTP_BAD_REQUEST);
		}
		else {
			$authorized_user = $this->login_model->authorize_user($username);
			$user_data = $authorized_user->row_array();
			
			if ($authorized_user->num_rows() === 0) {
                $this->response([
						'status' 	=> FALSE,
						'errors' 	=> 'unauthorized_access',
						'message' 	=> 'Username does not match'
					], VA_Controller::HTTP_UNAUTHORIZED);
			}
			else 
			{
			    
			    
			    $token = json_encode(array('email' => $user_data['email'], 'phone' => $user_data['phone']));
				$encryption_key = SECRET_KEY;
				$cipher_method = 'aes-128-cfb';
				$this->load->library('cryptor', array($encryption_key,$cipher_method));
				$crypted_token = $this->cryptor->encrypt($token);
				
				$user_data['token'] = $crypted_token;
				
				$this->response([
                    'status' 	=> TRUE,
                    'response' 	=> $user_data,
				], VA_Controller::HTTP_OK);
			}
		}
    }
    
    public function forgot_post()
    {
        $username = $this->post('username');
        
		
		if (empty($username)) {
			$this->response([
                    'status' 	=> FALSE,
					'errors' 	=> 'request_parameter_missing',
                    'message' 	=> 'No E-mail were provided'
                ], VA_Controller::HTTP_BAD_REQUEST);
		}
       
		else {
			$authorized_user = $this->login_model->email_exist($username);
			
			if ($authorized_user->num_rows() === 0) {
                $this->response([
						'status' 	=> FALSE,
						'errors' 	=> 'unauthorized_access',
						'message' 	=> 'E-mail does not match'
					], VA_Controller::HTTP_UNAUTHORIZED);
			}
			else {
			        $authorized_user_data=$authorized_user->row();
			        $password = $this->login_model->password_change($authorized_user_data->id);
			        // the message
					$msg = "Hi ".$authorized_user_data->first_name." ".$authorized_user_data->last_name.",<br/>";
					$msg.= "Your new password has been changed"."<br/>";
				
					$msg.= "<b>Password:</b> ".$password."<br/>";
					$msg.= "You can login with either with email as username";

					$headers = "MIME-Version: 1.0" . "\r\n";
					$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

					// send email
					@mail($authorized_user_data->email,"Suchita Volvo - Password Changed",$msg,$headers);
				
				$this->response([
                    'status' 	=> TRUE,
                    'response' 	=> 'E-mail sent',
				], VA_Controller::HTTP_OK);
			}
		}
    }
}
