<!doctype html>
<html lang="en-US">
<head>
   <meta charset="UTF-8">
   <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
   <title>MAX BRIDGE SOLUTION</title>
   <link rel="apple-touch-icon" sizes="57x57" href="/apple-icon-57x57.png">
   <link rel="apple-touch-icon" sizes="60x60" href="/apple-icon-60x60.png">
   <link rel="apple-touch-icon" sizes="72x72" href="/apple-icon-72x72.png">
   <link rel="apple-touch-icon" sizes="76x76" href="/apple-icon-76x76.png">
   <link rel="apple-touch-icon" sizes="114x114" href="/apple-icon-114x114.png">
   <link rel="apple-touch-icon" sizes="120x120" href="/apple-icon-120x120.png">
   <link rel="apple-touch-icon" sizes="144x144" href="/apple-icon-144x144.png">
   <link rel="apple-touch-icon" sizes="152x152" href="/apple-icon-152x152.png">
   <link rel="apple-touch-icon" sizes="180x180" href="/apple-icon-180x180.png">
   <link rel="icon" type="image/png" sizes="192x192"  href="/android-icon-192x192.png">
   <link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
   <link rel="icon" type="image/png" sizes="96x96" href="/favicon-96x96.png">
   <link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
   <link rel="manifest" href="manifest.json">
   <meta name="msapplication-TileColor" content="#ffffff">
   <meta name="msapplication-TileImage" content="/ms-icon-144x144.png">
   <meta name="theme-color" content="#ffffff">
   
   <!-- <link rel='stylesheet' href='css/main.css' type='text/css' media='screen' defer /> -->
   <link rel="stylesheet" href="css/home.css">
   <!-- <link rel="preload" href="css/main.css" as="style" onload="this.onload=document.getElementById('demo-loader').remove();null;this.rel='stylesheet'">
   <noscript><link rel="stylesheet" href="css/main.css"></noscript> -->
   <!-- <link href="main.css" rel="stylesheet" media="all"> -->
   <!-- <link href="mobile.css" rel="stylesheet" media="screen and (max-width: 600px)"> -->
   <!-- <script src="js/jquery.min.js"></script> -->
   
</head>
<body id="page-body">
   <!-- <div id="demo-loader" style="width:100%;height:100vh;position: fixed;z-index: 999;left: 0;top: 0;background: #eee;"></div> -->
<header class="header is-sticky">
   <div class="container">
      <div class="row">
         <div class="col-6 col-md-2">
            <a href="index.php" class="logo"><img src="images/logo.webp" alt="Maxbridge Solutions" width="100%" height="100%"></a>
         </div>
         <div class="col-6 col-md-10">
            <div class="hamburger" id="hamburger-1">
               <span class="line"></span>
               <span class="line"></span>
               <span class="line"></span>
            </div>
            <div class="main-nav">
               <nav>
                  <ul class="navbar-nav">
                     <li class="nav-item">
                        <a href="index.php" class="nav-link">Home</a>
                     </li>
                     <li class="nav-item">
                        <a href="who-we-are.php" class="nav-link">Who we are</a>
                        <!-- <ul>
                           <li><a href="who-we-are.php">About Maxbridge</a></li>
                           <li><a href="who-we-are.php#leadership-and-governance">Leadership and Governance</a></li>
                        </ul> -->
                     </li>
                     <li class="nav-item">
                        <a href="javascript:void(0);" class="nav-link">What We Do</a>
                        <ul>
                           <li>
                              <a href="application-development.php">Application Development</a>
                           </li>
                           <li>
                              <a href="javascript:void(0);">Digital Transformation</a>
                              <ul>
                                 <li><a href="cloud-service.php">Cloud Service</a></li>
                                 <li><a href="block-chain.php">Block Chain</a></li>
                              </ul>
                           </li>
                        </ul>
                     </li>
                     <li class="nav-item">
                        <a href="javascript:void(0);" class="nav-link">Industries</a>
                        <ul>
                           <li><a href="industries-banking-and-financial.php">Banking and Financial</a></li>
                           <li><a href="industries-retail-ecommerce.php">Retail & Ecommerce</a></li>
                           <li><a href="industries-education.php">Education</a></li>
                           <li><a href="industries-entertainment.php">Entertainment</a></li>
                        </ul>
                     </li>
                     <li class="nav-item">
                        <a href="javascript:void(0);" class="nav-link">Products</a>
                        <ul>
                           <li><a href="lead-management-system.php">Lead Management System</a></li>
                           <li><a href="hospital-management-system.php">Hospital Management System</a></li>
                        </ul>
                     </li>
                     <li class="nav-item">
                        <a href="career.php" class="nav-link">Career</a>
                     </li>
                     <li class="nav-item">
                        <a href="contact-us.php" class="nav-link">Contact us</a>
                     </li>
                  </ul>
               </nav>
            </div>
         </div>
      </div>
   </div>
</header>
<div id="content" class="site-content pt-66">
   <section class="home-banner-section">
      <div class="banner-up-txt">
         <div class="container">
            <div class="row">
               <div class="col-lg-12 text-left">
                  <h1>
                     Creating Digital moments of your <br>Business!
                  </h1>
                  <p class="mb-0">Making IT Smarter, Simpler, Faster.</p>
                  <!-- <div class="action-block text-left">
                     <a href="#" class="btn btn-white bra-7" id="sc-b">
                        EXPLORE MORE <i class="fa fa-long-arrow-down" aria-hidden="true"></i>
                     </a>
                  </div> -->
               </div>
            </div>
         </div>
      </div>
      <div class="banner-pic home-pic overlay-bg">
         <img src="images/home-banner.webp" alt="Making IT Smarter, Simpler, Faster">
      </div>
   </section>

   <section id="abaout-section" class="abaout-section">
      <div class="container">
         <div class="row">
            <div class="col-md-6">
               <div class="about-img mb-80">
                  <img src="images/about-img.webp" class="max-img" alt="About Maxbridge">
               </div>
               <div class="about-more">
                  <p>"Though we are optimistic, we have armored ourselves for the most caustic criticisms and the toughest challenges expected to come our way"</p>
                  <a href="who-we-are.php" class="btn btn-default">MORE ABOUT US</a>
               </div>
            </div>

            <div class="col-md-6">
               <div class="about-text">
                  <div class="section-title t_left">
                     <h6>ABOUT US</h6>

                     <h2><span>Providing outstanding digital transformation services and <br>IT solution</span></h2>
                  </div>
                  <p>We are a digital transformation service & IT solutions provider company with an ardent desire to give complete satisfaction to our customers in the technology field by designing, building, and implementing leading-edge software, web and mobile services for global innovation-driven businesses of different sizes. We are also a provider of customized software solutions, data-driven digital marketing, and cloud-based services for all kinds of small & medium enterprises to well-established blue-chip companies in enhancing their businesses. With an expert team of professionals, we deliver our projects, digital transformation services, and software products smoothly within a short span of time to the satisfaction of our clients.</p>
                  <div class="row mt-3 align-items-center">
                     <div class="col-2 col-md-1 pr-0"><img src="images/settings.svg"></div>
                     <div class="col-10 col-md-11">
                        <h3 class="mb-0">BEST QUALITY MANAGEMENT SOFTWARE</h3>

                     </div>
                     <div class="col-md-12 mt-2">
                        <p>An ISO 9001 certified IT company to deliver customer experience transformation to enable growth, innovation and data value by solving complex problems.</p>
                        <div class="custom-slider-bar maxw-350">
                           <div class="custom-slider-block">
                              <div class="custom-slider-line" data-content="95">
                                 <div class="custom-slider-knob"></div>
                              </div>
                              <div class="custom-slider-txt">95%</div>
                           </div>
                        </div>
                     </div>
                  </div>

                  <div class="row mt-3 align-items-center">
                     <div class="col-2 col-md-1 pr-0"><img src="images/monitor.svg"></div>
                     <div class="col-10 col-md-11">
                        <h3 class="mb-0">ROBUST APPLICATION MANAGEMENT</h3>
                     </div>
                     <div class="col-md-12 mt-2">
                        <p>Specialist in solving complex IT business challenges with suitable digital transformation technology, agile, and platform-driven method by an expert & skilled management.</p>
                        <div class="custom-slider-bar maxw-350">
                           <div class="custom-slider-block">

                              <div class="custom-slider-line" data-content="92">
                                 <div class="custom-slider-knob"></div>
                              </div>
                              <div class="custom-slider-txt">92%</div>
                           </div>
                        </div>
                     </div>
                  </div>

                  <div class="row mt-3">
                     <div class="col-md-12">
                        <div class="about-round-pic"><img src="images/about-pic3.webp" alt="Specialist in solving"></div>
                     </div>
                  </div>

               </div>
            </div>

         </div>
      </div>
   </section>

   <section class="highlights-ar pt-5 pb-5">
      <div class="container">
         <div class="row">
            <div class="col-md-12">
               <h2 class="default-title mb-35 text-bold">Customer <span>Stories</span></h2>
            </div>
            <div class="col-md-12">
               <div class="sp-portfolio">
                  <div class="proj large super-styles">
                     <div class="hover-title">LMSBABA <i class="fa fa-long-arrow-right" aria-hidden="true"></i></div>
                     <div class="hover-block">
                        <div class="inner">
                           <!-- <div class="inner-pic"><img src="images/lap.png"></div> -->
                           <div class="name-cover"></div>
                           <div class="title">LMSBABA</div>
                           <div class="desc">Introducing Advanced Online Lead Management System</div>
                           <div class="panda-btn flat">View Project</div>
                           <div class="popup-content">
                              <h2>LMSBABA</h2>
                              <p>LMS Baba is a Sales Management Application which automatically captures, collates and distributes leads from multiple channels among the sales team members. It enables them to engage, follow, quote and convert prospective buyers through an organized, highly structured and automated system leading to improved conversion and people productivity.</p>
                              <figure><img src="images/3.webp" alt="LMSBABA"></figure>
                           </div>
                        </div>
                     </div>
                     <div class="backimg"><img src="images/3.webp" alt="LMSBABA"></div>
                  </div>
                  <div class="proj small super-styles">
                     <div class="hover-title">FIO WORLD <i class="fa fa-long-arrow-right" aria-hidden="true"></i></div>
                     <div class="hover-block">
                        <div class="inner">
                           <div class="name-cover"></div>
                           <div class="title">FIO WORLD</div>
                           <div class="desc">Showcase your creative talent to the world</div>
                           <div class="panda-btn flat">View Project</div>
                           <div class="popup-content">
                              <h2>FIO WORLD</h2>
                              <p>FIO has partnered with fashion events across the world. Gain access to various fashion weeks, trade fairs, workshops and pop-ups across the world.</p>
                              <figure><img src="images/2.webp" alt="FIO WORLD"></figure>
                           </div>
                        </div>
                     </div>
                     <div class="backimg"><img src="images/2.webp" alt="FIO WORLD"></div>
                  </div>
                  <div class="proj small super-styles">
                     <div class="hover-title">OPENLM <i class="fa fa-long-arrow-right" aria-hidden="true"></i></div>
                     <div class="hover-block">
                        <div class="inner">
                           <div class="name-cover"></div>
                           <div class="title">OPENLM</div>
                           <div class="desc">Software Asset Management for Engineering Licenses</div>
                           <div class="panda-btn flat">View Project</div>
                           <div class="popup-content">
                              <h2>OPENLM</h2>
                              <p>OpenLM is the only real alternative to Flexera's “FlexNet Manager for Engineering Applications” for monitoring and controlling FlexLM licenses.</p>
                              <figure><img src="images/hi3.webp" alt="OPENLM"></figure>
                           </div>
                        </div>
                     </div>
                     <div class="backimg"><img src="images/hi3.webp" alt="OPENLM"></div>
                  </div>
                  <div class="proj small super-styles">
                     <div class="hover-title">TCBPAY <i class="fa fa-long-arrow-right" aria-hidden="true"></i></div>
                     <div class="hover-block">
                        <div class="inner">
                           <div class="name-cover"></div>
                           <div class="title">TCBPAY</div>
                           <div class="desc">Global payment processing solutions for all businesses.</div>
                           <div class="panda-btn flat">View Project</div>
                           <div class="popup-content">
                              <h2>TCBPAY</h2>
                              <p>Accept card payments from anywhere with our TCB Pay app. It is compatible with phones and tablets and provides fast, reliable and secure transactions.</p>
                              <figure><img src="images/4.webp" alt="TCBPAY"></figure>
                           </div>
                        </div>
                     </div>
                     <div class="backimg"><img src="images/4.webp" alt="TCBPAY"></div>
                  </div>
                  <div class="proj small super-styles">
                     <div class="hover-title">THE FIT CHASE <i class="fa fa-long-arrow-right" aria-hidden="true"></i></div>
                     <div class="hover-block">
                        <div class="inner">
                           <div class="name-cover"></div>
                           <div class="title">THE FIT CHASE</div>
                           <div class="desc">Online fitness coaching customised to your lifestyle.</div>
                           <div class="panda-btn flat">View Project</div>
                           <div class="popup-content">
                              <h2>THE FIT CHASE</h2>
                              <p>Online fitness coaching customised to your lifestyle. Work one-on-one with a certified fitness professional, dedicated towards your goal.</p>
                              <figure><img src="images/5.webp" alt="THE FIT CHASE"></figure>
                           </div>
                        </div>
                     </div>
                     <div class="backimg"><img src="images/5.webp" alt="THE FIT CHASE"></div>
                  </div>
                  <div class="clear"></div>
               </div>
            </div>
         </div>
      </div>
   </section>

   <section class="estimate-section pt-5 pb-5">
      <div class="container">
         <div class="row">
            <div class="col-md-12">
               <h2 class="gradient-box">How Much Does Is Cost To Make An App For Website 
                  <!-- <a href="#" class="sm" data-bs-toggle="modal" data-bs-target="#getEstimateModal">Get Estimate</a> -->
                  <a href="mailto:info@maxbridgesolution.com?subject=Get Estimate" class="sm">Get Estimate</a>
               </h2>
            </div>
         </div>
      </div>
   </section>

   <section class="highlights-ar pt-20 pb-20">
      <div class="container">
          <div class="row show-counter">
              <div class="col-md-3 col-sm-6">
                  <div class="counter">
                      <div class="counter-content">
                          <div class="counter-icon">
                              <img src="images/projects.svg">
                          </div>
                          <span><span class="counter-value">1000</span>+</span>
                          <h3>Projects</h3>
                          
                      </div>
                  </div>
              </div>
              <div class="col-md-3 col-sm-6">
                  <div class="counter orange">
                      <div class="counter-content">
                          <div class="counter-icon">
                              <img src="images/clients.svg">
                          </div>
                          <span><span class="counter-value">250</span>+</span>
                          <h3>Clients</h3>
                          
                      </div>
                  </div>
              </div>
              <div class="col-md-3 col-sm-6">
                  <div class="counter purple">
                      <div class="counter-content">
                          <div class="counter-icon">
                              <img src="images/developers.svg">
                          </div>
                          <span><span class="counter-value">50</span>+</span>
                          <h3>Developers</h3>
                          
                      </div>
                  </div>
              </div>
              <div class="col-md-3 col-sm-6">
                  <div class="counter green">
                      <div class="counter-content">
                          <div class="counter-icon">
                              <img src="images/satisfaction.svg">
                          </div>
                          <span>&infin;</span>
                          <h3>Satisfaction</h3>
                          
                      </div>
                  </div>
              </div>
          </div>

      </div>
   </section>

   <section class="light-blue-section pt-5 pb-5">
      <div class="container">
         <div class="row mb-50">
            <div class="col-md-12">
               <div class="inno-box">
                  <div class="inno-auto">
                     <figure><img src="images/inno-1.png" alt=""></figure>
                     <figcaption>Design in Innovation</figcaption>
                  </div>
                  <div class="inno-auto">
                     <figure><img src="images/inno-2.png" alt=""></figure>
                     <figcaption>Professional Thinking & Solutions</figcaption>
                  </div>
               </div>
            </div>
         </div>

         <div class="row row-gap-30">
            
            <div class="col-md-6">
               <div class="flip-outer">
                  <div class="flip-card">
                     <div class="flip-card-inner">
                        <div class="flip-card-front">
                           <div class="inno-content-up">Digital Strategy</div>
                        </div>
                        <div class="flip-card-back">
                           <div class="b-content">
                              <h2>Digital Strategy</h2>
                              <div class="inno-others">
                                 <p>Redefining new possibilities to enable successful digital transformation services and IT Solutions to market ready actions.</p>
                                 <ul class="icon-ul">
                                    <li>Consulting Overview and Cloud Services</li>
                                    <li>Customer Experience Transformation</li>
                                    <li>Product and Service Innovation</li>
                                    <li>Data & Intelligence Services</li>
                                 </ul>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <img src="images/inno-bg-1.webp" alt="Redefining new possibilities to enable successful" class="img-full">
               </div>
               
            </div>

            <div class="col-md-6">
               <div class="flip-outer bg-2">
                  <div class="flip-card">
                     <div class="flip-card-inner">
                        <div class="flip-card-front">
                           <div class="inno-content-up">IT-Consulting</div>
                        </div>
                        <div class="flip-card-back">
                           <div class="b-content">
                              <h2>IT-Consulting</h2>
                              <div class="inno-others">
                                 <p>Presenting advanced data analytics concepts and data techniques.</p>
                                 <ul class="icon-ul">
                                    <li>Management consulting</li>
                                    <li>Enterprise technology and performance</li>
                                    <li>IT budgeting and planning</li>
                                    <li>Risk consulting</li>
                                 </ul>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <img src="images/inno-bg-2.webp" alt="Presenting advanced data analytics" class="img-full">
               </div>
               
            </div>

            <div class="col-md-6">
               <div class="flip-outer bg-3">
                  <div class="flip-card">
                     <div class="flip-card-inner">
                        <div class="flip-card-front">
                           <div class="inno-content-up">Technological Experience</div>
                        </div>
                        <div class="flip-card-back">
                           <div class="b-content">
                              <h2>Technological Experience</h2>
                              <div class="inno-others">
                                 <p>Provides uninterrupted & conceptual experiences to our modern day technology users with the best innovative services and business solutions to the satisfaction of our clients.</p>
                                 <ul class="icon-ul">
                                    <li>industry automation</li>
                                    <li>ERP support</li>
                                    <li>Web Application Development</li>
                                    <li>automatic intelligence</li>
                                 </ul>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <img src="images/inno-bg-3.webp" alt="Provides uninterrupted & conceptual experiences" class="img-full">
               </div>
               
            </div>

            <div class="col-md-6">
               <div class="flip-outer bg-4">
                  <div class="flip-card">
                     <div class="flip-card-inner">
                        <div class="flip-card-front">
                           <div class="inno-content-up">Operational Experience</div>
                        </div>
                        <div class="flip-card-back">
                           <div class="b-content">
                              <h2>Operational Experience</h2>
                              <div class="inno-others">
                                 <p>Operations in the IT environment always need adequateknowledge base support & monitoring through experts and professionals who can deliver safe and secure solutions to the client’s satisfaction.</p>
                                 <ul class="icon-ul">
                                    <li>Enterprise application support.</li>
                                    <li>Automation of IT infrastructure.</li>
                                    <li>Cloud management and optimization.</li>
                                    <li>IT outsourcing</li>
                                 </ul>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <img src="images/inno-bg-4.webp" alt="Operations in the IT" class="img-full">
               </div>
               
            </div>

         </div>

      </div>
   </section>

   <section class="focus-section pt-5 pb-5">
      <div class="container">
         <div class="row">
            <div class="col-md-12">
               <div class="custom-owl-outer">
                  <div class="custom-owl-content">
                     <h2 class="default-title mb-35 text-bold text-left">Our <span>Focus</span></h2>
                     <p>Our main focus is customer satisfaction by excellent planning, developing, showcasing & delivering end product.</p>
                     <div class="custom-owl-nav"-holder>
                        <a href="#" class="custom-owl-nav custom-owl-prev"><i class="fa fa-long-arrow-left" aria-hidden="true"></i></a>
                        <a href="#" class="custom-owl-nav custom-owl-next"><i class="fa fa-long-arrow-right" aria-hidden="true"></i></a>
                     </div>
                  </div>
                  <div class="focus-carousel-holder">
                     <div id="focus-carousel" class="owl-carousel owl-theme">
                         <div class="item">
                            <div class="focus-item">
                               <figure><img src="images/f1.webp" alt="Sustainable Growth"></figure>
                               <figcaption>
                                  <h3 class="matchHeight">Sustainable Growth</h3>
                                  <!-- <a href="#" class="read-more">Read More <i class="fa fa-angle-right" aria-hidden="true"></i></a> -->
                               </figcaption>
                            </div>
                         </div>
                         <div class="item">
                            <div class="focus-item">
                               <figure><img src="images/f2.webp" alt="Web Based Solutions"></figure>
                               <figcaption>
                                  <h3 class="matchHeight">Web Based Solutions</h3>
                                  <!-- <a href="#" class="read-more">Read More <i class="fa fa-angle-right" aria-hidden="true"></i></a> -->
                               </figcaption>
                            </div>
                         </div>
                         <div class="item">
                            <div class="focus-item">
                               <figure><img src="images/f3.webp" alt="Consultation Services"></figure>
                               <figcaption>
                                  <h3 class="matchHeight">Consultation Services</h3>
                                  <!-- <a href="#" class="read-more">Read More <i class="fa fa-angle-right" aria-hidden="true"></i></a> -->
                               </figcaption>
                            </div>
                         </div>

                         <div class="item">
                            <div class="focus-item">
                               <figure><img src="images/f4.webp" alt="Advanced Technological Implementation"></figure>
                               <figcaption>
                                  <h3 class="matchHeight">Advanced Technological Implementation</h3>
                                  <!-- <a href="#" class="read-more">Read More <i class="fa fa-angle-right" aria-hidden="true"></i></a> -->
                               </figcaption>
                            </div>
                         </div>

                         <div class="item">
                            <div class="focus-item">
                               <figure><img src="images/f5.webp" alt="Technical Expertise & Deliverance"></figure>
                               <figcaption>
                                  <h3 class="matchHeight">Technical Expertise & Deliverance</h3>
                                  <!-- <a href="#" class="read-more">Read More <i class="fa fa-angle-right" aria-hidden="true"></i></a> -->
                               </figcaption>
                            </div>
                         </div>

                         <div class="item">
                            <div class="focus-item">
                               <figure><img src="images/f6.webp" alt="Digital Technological Support & Solution"></figure>
                               <figcaption>
                                  <h3 class="matchHeight">Digital Technological Support & Solution</h3>
                                  <!-- <a href="#" class="read-more">Read More <i class="fa fa-angle-right" aria-hidden="true"></i></a> -->
                               </figcaption>
                            </div>
                         </div>

                     </div>
                  </div>
               </div>
            </div>
            
         </div>
      </div>
   </section>

   <section class="start-up-section pt-5 pb-5">
      <div class="container">
         <div class="row">
            <div class="col-md-12">
               <h3>Got A Startup Idea & Need To Get It Validated?</h3>
               <div class="gradient-box sm-box">Book Your FREE 30 minutes Consultation With Experts! 
                  <!-- <a href="#" class="btn btn-white" data-bs-toggle="modal" data-bs-target="#getEstimateModal">Book Now! <i class="fa fa-long-arrow-down" aria-hidden="true"></i></a> -->
                  <a href="mailto:info@maxbridgesolution.com?subject=30 minutes Consultation With Experts!" class="btn btn-white">Book Now!</a>
               </div>
            </div>
         </div>
      </div>
   </section>

   <section class="abaout-ar mt-5 mb-5">
      <div class="container">
         <div class="row">
            <div class="col-md-12 mb-5">
               <h2 class="default-title text-center text-bold">Testimonials</h2>
                <p class="text-center default-text">What our customers says</p>
            </div>
            <div class="col-md-12 col-sm-12 ambassador-wrapper new mplr-40">
               <div id="review-carousel" class="owl-carousel owl-theme">
                  <div class="item">
                     <div class="content-wrap">
                        <p>“Associated with Maxbridge Solutions since last 5 years, I must say I got the right team what I was looking for my regular projects. This team is having people with the great knowledge of site architecture, DB architecture, UI/UX & right coding.”</p>
                        <!-- <div class="rating-wrapper text-center">
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                        </div> -->
                     </div>
                     <div class="img-wrap">
                        <img src="images/shashi.webp" class="img-responsive" alt="Shashi Narain">
                        <div class="content">
                           <h4>Shashi Narain</h4>
                           <p>Owner of Srishti Ventures Inc.</p>
                        </div>
                     </div>
                  </div>
                  <div class="item">
                     <div class="content-wrap">
                        <p>“There are a lot of programmers and developers from India on here, but very few are as good as these guys. I highly recommend them.”</p>
                        <!-- <div class="rating-wrapper text-center">
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                        </div> -->
                     </div>
                     <div class="img-wrap">
                        <img src="images/person_icon.webp" class="img-responsive" alt="Isamu Himura">
                        <div class="content">
                           <h4>Isamu Himura</h4>
                           <p>CEO</p>
                        </div>
                     </div>
                  </div>
                  <div class="item">
                     <div class="content-wrap">
                        <p>“Maxbridge is a serious company to work with. They deliverd fast and did a great job. I have already hired them for more work.”</p>
                        <!-- <div class="rating-wrapper text-center">
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                        </div> -->
                     </div>
                     <div class="img-wrap">
                        <img src="images/person_icon.webp" class="img-responsive" alt="Hans Anderson">
                        <div class="content">
                           <h4>Hans Anderson</h4>
                           <p>Founder, Sonit Solutions</p>
                        </div>
                     </div>
                  </div>

                  <div class="item">
                     <div class="content-wrap">
                        <h2 class="text-center mb-2"><strong>"Very knowledgeable"</strong></h2>
                        <p>
                           The people at MaxBridges Solutions are a pleasure to work with. They are very knowledgeable, dependable, they deliver with quick turnaround, and provide the expertise I need in all areas of Web development.
                        </p>
                        <!-- <div class="rating-wrapper text-center">
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                        </div> -->
                     </div>
                     <div class="img-wrap">
                        <img src="images/person_icon.webp" class="img-responsive" alt="Anthony R.">
                        <div class="content">
                           <h4>Anthony R.</h4>
                           <p>Web Designer, USA</p>
                        </div>
                     </div>
                  </div>

                  <div class="item">
                     <div class="content-wrap">
                        <h2 class="text-center mb-2"><strong>"Awesome experience"</strong></h2>
                        <p>
                           This freelancer while new is GREAT! I have used Freelancer a lot over the last 2 years and he is one of the best I have ever worked with. Great communication and underst.
                        </p>
                        <!-- <div class="rating-wrapper text-center">
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                           <span class="fa fa-star checked"></span>
                        </div> -->
                     </div>
                     <div class="img-wrap">
                        <img src="images/person_icon.webp" class="img-responsive" alt="Sergio Villasenor">
                        <div class="content">
                           <h4>Sergio Villasenor</h4>
                           <p>Founder & CEO of Elliot</p>
                        </div>
                     </div>
                  </div>

               </div>
            </div>

            <div class="col-md-6 col-sm-6 ambassador-wrapper new mplr-40" style="display:none">
               <div id="testo-carousel" class="owl-carousel owl-theme">
                  <div class="item">
                     <video id="test-video-1" width="320" height="240" controls poster="images/testo-1.jpg">
                        <source src="video/testimonial.mp4" type="video/mp4">
                        Your browser does not support the video tag.
                     </video>
                     <!-- <a href="#" class="testo-video">
                        <i class="fa fa-youtube-play" aria-hidden="true"></i>
                        <video id="test-video-1" width="320" height="240" controls poster="images/testo-1.jpg">
                           <source src="video/testimonial.mp4" type="video/mp4">
                           Your browser does not support the video tag.
                        </video>
                     </a> -->
                  </div>
                  <!-- <div class="item">
                     <a href="Bq3wYElBdQM" class="testo-video">
                        <i class="fa fa-youtube-play" aria-hidden="true"></i>
                        <img src="images/testo-2.jpg">
                     </a>
                  </div>
                  <div class="item">
                     <a href="Bq3wYElBdQM" class="testo-video">
                        <i class="fa fa-youtube-play" aria-hidden="true"></i>
                        <img src="images/testo-3.jpg">
                     </a>
                  </div>
                  <div class="item">
                     <a href="Bq3wYElBdQM" class="testo-video">
                        <i class="fa fa-youtube-play" aria-hidden="true"></i>
                        <img src="images/testo-4.jpg">
                     </a>
                  </div> -->
               </div>
            </div>

         </div>
      </div>
   </section>
 
   <!-- <section class="image-bg pt-40 pb-40">
      <div class="bg-overlay">
         <div class="container">
            <div class="col-md-12">
               <p>What makes us, uniquely us? Our story, our <br>approach, our insights. Come meet the <br>people that create human-shaped experiences.</p>
               <a href="#">Who We Are <i class="fa fa-caret-right" aria-hidden="true"></i></a>
            </div>
         </div>
      </div>
   </section> -->

   <!-- <section class="call-grad-section pt-70 pb-55">
      <div class="container">
         <div class="row">
            <div class="col-md-12">
               <h3>We Deliver <strong>100 Web & Mobile <br>Projects</strong> per Year</h3>
               <p>Lets Connect and Book a call</p>
               <a href="#" class="btn btn-white">Connect us!</a>
            </div>
         </div>
      </div>
   </section> -->

   <section class="talk-section pt-5 pb-5">
      <div class="container">
         <div class="row">
            <div class="col-md-7">
               <div class="talk-form-box">
                  <h2 class="text-center">LET'S TALK</h2>
                  <p class="text-center">So let's get in touch and turn your app idea into a brilliant mobile app solution.</p>
                  <form>
                     
                     <div class="form-group col-justi-bet">
                        <div class="w-234 mob-mb-15">
                           <label class="default-label">Name(<span>*</span>)</label>
                           <div class="w-100"><input class="default-input" type="text" name=""></div>  
                        </div>
                        <div class="w-234 mob-mb-15">
                           <label class="default-label">Email(<span>*</span>)</label>
                           <div class="w-100"><input class="default-input" type="email" name=""></div>  
                        </div>
                     </div>

                     <div class="form-group col-justi-bet">
                        <div class="w-234 mob-mb-15">
                           <label class="default-label">Skype Id(<span>*</span>)</label>
                           <div class="w-100"><input class="default-input" type="text" name=""></div>  
                        </div>
                        <div class="w-234 mob-mb-15">
                           <label class="default-label">Whatsapp No.(<span>*</span>)</label>
                           <div class="w-100"><input class="default-input" type="email" name=""></div>  
                        </div>
                     </div>

                     <div class="form-group col-justi-bet">
                        <div class="w-234 mob-mb-15">
                           <label class="default-label">Interested In(<span>*</span>)</label>
                           <div class="w-100"><input class="default-input" type="text" name=""></div>  
                        </div>
                        <div class="w-234 mob-mb-15">
                           <label class="default-label">Your Budget(<span>*</span>)</label>
                           <div class="w-100"><input class="default-input" type="email" name=""></div>  
                        </div>
                     </div>

                     <div class="form-group">
                        <div class="w-100">
                           <label class="default-label">Message</label>
                           <div class="w-100"><textarea class="default-textarea mh-160"></textarea></div>  
                        </div>
                     </div>


                     <div class="form-action text-right">
                        <a href="#" class="btn btn-border">SEND YOUR INQUIRY <i class="fa fa-long-arrow-down" aria-hidden="true"></i></a>
                     </div>

                  </form>
               </div>
            </div>
            <div class="col-md-5">
               <div class="talk-box-holder">

                  <div class="talk-box">
                     <div class="dbox w-100 d-flex align-items-center mb-2">
                        <div class="icon d-flex align-items-center justify-content-center">
                           <span class="fa fa-map-marker"></span>
                        </div>
                        <div class="text pl-3">
                           <h6 style="font-size:14px;">Room No. 401, Webel Tower- I, </h6>
                           <h6 style="font-size:14px;">4th Floor, BN4, BN Block, Sector V</h6>
                           <h6 style="font-size:14px;">Salt Lake, Kolkata –700091 </h6>
                        </div>
                     </div>
                  </div>

                  <div class="talk-box">
                     <div class="dbox w-100 d-flex align-items-center mb-2">
                        <div class="icon d-flex align-items-center justify-content-center">
                           <span class="fa fa-envelope"></span>
                        </div>
                        <div class="text pl-3">
                           <p><a href="mailto:info@maxbridgesolution.com">info@maxbridgesolution.com</a></p>
                        </div>
                     </div>
                  </div>


                  <div class="talk-box">
                     <div class="dbox w-100 d-flex align-items-center mb-2">
                        <div class="icon d-flex align-items-center justify-content-center">
                           <span class="fa fa-skype"></span>
                        </div>
                        <div class="text pl-3">
                           <p><a href="skype:niladri.debnath?chat">niladri.debnath</a></p>
                        </div>
                     </div>
                  </div>

                  <!--<div class="talk-box">
                     <span><img src="images/talk-3.png"></span> WHATSAPP: (+91)-
                  </div>-->

               </div>
            </div>
         </div>
      </div>
   </section>

</div>

<?php include 'include/footer.php';?>
<script type="text/javascript">

   $(document).ready(function () {
      $('.sp-portfolio .proj .hover-block .panda-btn').click(function(event){
         event.preventDefault();
         var cname = $(this).parent().find('.popup-content h2').html();
         var ccontent = $(this).parent().find('.popup-content p').html();
         var cpic = $(this).parent().find('.popup-content figure').html();
         $('#projectDetailModal .pop-client-name').html(cname);
         $('#projectDetailModal .pop-client-details').html(ccontent);
         $('#projectDetailModal .full-img').html(cpic);
         $('#projectDetailModal').modal('show');
      });
      //custom-slider-bar
      $("#sc-b").click(function() {
          $('html, body').animate({
              scrollTop: $("#abaout-section").offset().top-60
          }, 600);
      });
      $('div.custom-slider-bar').on('inview', function(event, isInView) {
         if (isInView) {
            // custom-slider-line
            var $data = $(this).find('.custom-slider-line').attr('data-content');
            //alert($data);
            $(this).find('.custom-slider-knob').css({'left': $data+'%'})
         } else {
            // element has gone out of viewport
         }
      });
      var focus_carousel = $('#focus-carousel').owlCarousel({
          loop:false,
          margin:30,
          nav:false,
          dots:false,
          autoWidth:true,
          responsive:{
              0:{
                  items:1,
                  margin:15,
                  autoWidth:false
              },
              600:{
                  items:2
              },
              1000:{
                  items:2
              }
          }
      })
      $( "a.custom-owl-prev" ).click(function( event ) {
         event.preventDefault();
         focus_carousel.trigger('prev.owl.carousel');
        
      });
      $( "a.custom-owl-next" ).click(function( event ) {
         event.preventDefault();
         focus_carousel.trigger('next.owl.carousel');
        
      });
      $('.show-counter').on('inview', function(event, isInView) {
        if (isInView) {
          // element is now visible in the viewport
            $('.counter-value').each(function(){
                 $(this).prop('Counter',0).animate({
                     Counter: $(this).text()
                 },{
                     duration: 3500,
                     easing: 'swing',
                     step: function (now){
                         $(this).text(Math.ceil(now));
                     }
                 });
            });
        } else {
          // element has gone out of viewport
        }
      });
      //testo-video
      // $( "a.testo-video" ).click(function( event ) {
      //    event.preventDefault();
      //    $('video#test-video-1').trigger('play');
      //    $(this).find('.fa').hide();
      // });
      ////////
   });
</script>